import os
import pickle
import argparse
from typing import Dict, DefaultDict, List, Any, Tuple, Optional

from experiments.src.generate_market import generate_synthetic_data

def create_pkl_data(
        dispersion: float,
        alpha: float,
        max_try: int,
        recruiting_numbers_list: List[int],
        fnum: int,
    ):

    if dispersion == 1.0:
        dispersion = 1
    if dispersion == 0.0:
        dispersion = 0  

    varepsilon = 1

    siblings_fnum = int(alpha*fnum)


    dnum = int(0.1*fnum)


    for r in range(max_try):

        dirsname = f'experiments/synthetic_data/data_pkl_paper_phi_{dispersion}_alpha_{alpha}'
        filename = f'experiments/synthetic_data/data_pkl_paper_phi_{dispersion}_alpha_{alpha}/artificial_data_fnum_{fnum}_{r}_phi_{dispersion}_alpha_{alpha}.pkl'

        if not os.path.isdir(dirsname):
            os.makedirs(dirsname)

        if not os.path.isfile(filename):
            children_dic, daycares_dic, families_dic = generate_synthetic_data(
                fnum = fnum, 
                siblings_fnum = siblings_fnum, 
                dnum = dnum, 
                recruiting_numbers_list = recruiting_numbers_list,
                dispersions = dispersion, 
                varepsilon = varepsilon
                )
            with open(filename, 'wb') as f:
                pickle.dump([children_dic, daycares_dic, families_dic], f)



# if __name__ == '__main__':
#     psr  = argparse.ArgumentParser(
#         prog='人工選好データの生成コード',
#         usage='コマンドの後に、4つのパラメータを入力',
#         description='プログラムの説明'
#     )

#     # add_argumentメソッドを使って、コマンドラインから引数を受け取る処理を作成する
#     psr.add_argument('-dispersion', '--first', required=True, help='phiの値')
#     psr.add_argument('-alpha', '--second', required=True, help='alphaの値')

#     psr.add_argument('-alpha', '--second', required=True, help='試行回数')
#     psr.add_argument('-alpha', '--second', required=True, help='家族の数')

#     # 受け取った引数を解析する
#     args = psr.parse_args()


#     dispersion = float(args.first)
#     if dispersion == 1.0:
#         dispersion = 1
#     if dispersion == 0.0:
#         dispersion = 0  
#     alpha = float(args.second)

#     max_try = int(args.third)

#     fnum = int(args.forth)

#     create_pkl_data(dispersion, alpha, max_try, fnum)
