import numpy as np
import random
from typing import Dict, DefaultDict, List, Any, Tuple, Optional
from preflibtools.instances import OrdinalInstance

# populate_mallows(num_voters, num_alternatives, mixture, dispersions, references):
# Populates the instance with a random profile of strict preferences taken from a mixture of Mallows’ models. Uses preflibtools.instances.sampling for sampling.
# Parameters
# num_voters (int) – Number of orders to sample.
# num_alternatives (int) – Number of alternatives for the sampled orders.
# mixture (list of positive numbers) – A list of the weights of each element of the mixture.
# dispersions (list of float) – A list of the dispersion coefficient of each element of the mixture.
# references (list of tuples of tuples of int) – A list of the reference orders for each element of the mixture.


def generate_priority_by_mallows(
        original_priority: List[int], 
        dispersions: float
    ) -> List[int]:

    if dispersions == 0.0:
        outcome_priority = original_priority
    elif dispersions == 1.0:
        outcome_priority = list(np.random.permutation(original_priority))
    else:
        instance = OrdinalInstance()
        instance.populate_mallows(1, len(original_priority), [1],[dispersions],[original_priority])
        new_priority = instance.vote_map()
        outcome_priority = [d[0] for d in list(new_priority)[0]]
    return outcome_priority

def generate_original_priority(
        n: int, 
        families_dic: DefaultDict[int, DefaultDict[str, Any]], 
        varepsilon: float
    ) -> List[int]:
    
    original_priority: List[int] = []
    for key in families_dic:
        if len(families_dic[key]['children']) == 1:
            original_priority.append(families_dic[key]['children'][0])
        else:
            if random.random() < 1.0/(n**(1+varepsilon)):
                for c in families_dic[key]['children']:
                    original_priority.append(c)
            else:
                original_priority.append(- 1 * key)
    original_priority = np.random.permutation(original_priority)
    new_original_priority: List[int] = []
    for id in original_priority:
        if id<0:
            for c in families_dic[-1 * id]['children']:
                new_original_priority.append(c)
        else:
            new_original_priority.append(id)

    return new_original_priority