from typing import Dict, DefaultDict, List, Any, Tuple, Optional
import random

from initialization.agent_Class import SDA_Child, SDA_Daycare, SDA_Family


def randomize_priority(
        children: List[SDA_Child], 
        daycares: List[SDA_Daycare], 
        families: List[SDA_Family]
    ) -> Tuple[
        List[SDA_Child], 
        List[SDA_Daycare], 
        List[SDA_Family],
    ]:
    
    #  shuffle priority
    for d in daycares:

        pos_initial = -1
        for c in d.priority:

            # 転園希望の子供たちの優先順位は変えない
            if c.initial_daycare == d.id:
                pos_initial = d.priority.index(c)

        Y = [i for i in range(pos_initial+1, len(d.priority), 1)]
        random.shuffle(Y)

        new = [x for _, x in sorted(zip(Y, d.priority[pos_initial+1:]))]
        d.priority = d.priority[:pos_initial+1] + new
    
    return children, daycares, families



def reverse_priority(
        children: List[SDA_Child], 
        daycares: List[SDA_Daycare], 
        families: List[SDA_Family]
    ) -> Tuple[
        List[SDA_Child], 
        List[SDA_Daycare], 
        List[SDA_Family],
    ]:

    # reverse
    for d in daycares:

        x = random.uniform(0,1)

        if x >= 0.5:

            pos_initial = 0
            for c in d.priority:
                if c.initial_daycare == d.id:
                    pos_initial = d.priority.index(c)

            if pos_initial != 0:
                d.priority = d.priority[:pos_initial+1] + d.priority[len(d.priority):pos_initial:-1]

            else:
                d.priority = d.priority[::-1]

    return children, daycares, families


def perturb_by_mallows(
        children: List[SDA_Child], 
        daycares: List[SDA_Daycare], 
        families: List[SDA_Family],
        dispersions: float
    ) -> Tuple[
        List[SDA_Child], 
        List[SDA_Daycare], 
        List[SDA_Family],
    ]:
    
    from preflibtools.instances import OrdinalInstance
    
    #  shuffle priority
    for d in daycares:

        pos_initial = -1
        for c in d.priority:
            if c.initial_daycare == d.id:
                pos_initial = d.priority.index(c)

        Y = [i for i in range(pos_initial+1, len(d.priority), 1)]
        if Y != []:
            instance = OrdinalInstance()
            instance.populate_mallows(1, len(Y), [1],[dispersions],[Y])
            new_pref = instance.vote_map()
            new = [d[0] for d in list(new_pref)[0]]
            new_2 = [x for _, x in sorted(zip(new, d.priority[pos_initial+1:]))]

            d.priority = d.priority[:pos_initial+1] + new_2
    
    return children, daycares, families
