import copy
import time
from typing import Dict, List, Any, Tuple, Optional

from initialization.agent_Class import SDA_Child, SDA_Daycare, SDA_Family
from utils.get_agent import get_agent

from main.children_propose_da import children_propose_da
from main.choice_functions.choice_function_for_family import choice_function_for_family
from main.choice_functions.choice_function_for_child import choice_function_for_child


def update_pi(
        pi: List[int], 
        j: int, 
        i: int
    ) -> List[int]:
    """
    Swaps the elements at indices i and j in the permutation pi to create a new permutation pi_prime.
    
    Parameters:
    - pi: The original list representing a permutation.
    - j: The index of the first element to swap.
    - i: The index of the second element to swap.

    Returns:
    - A new list representing the permutation after the swap.
    """

    pi_prime: List[int] = []
    for _ in range(len(pi)):
        pi_prime.append(0)
    for ind in range(0,j):
        pi_prime[ind]=pi[ind]
    pi_prime[j] = pi[i]
    for ind in range(j+1,i+1):
        pi_prime[ind] = pi[ind-1]
    for ind in range(i+1,len(pi)):
        pi_prime[ind] = pi[ind]

    return pi_prime






def whether_go_next_step(
        pi: List[int], 
        pi_i: int, 
        having_siblings_families: List[SDA_Family], 
        family_next_rank: Dict[int, int], 
        Pi_set: List[List[int]], 
        already_matched_family: List[SDA_Family], 
        child_next_rank: Dict[int, int], 
        Algorithm_terminated: bool, 
        B_total: List[SDA_Child]
    ) -> Tuple[
        bool, 
        bool, 
        bool, 
        List[int], 
        List[List[int]], 
        List[SDA_Child]
    ]:
    """
    Determines whether to proceed to the next step of the SDA algorithm,
    potentially updating the permutation of families and reassigning children.

    Parameters:
    ----------
    pi : List[int]
        The current permutation of family indices being considered.
    pi_i : int
        The index of the current family in the permutation.
    having_siblings_families : List[Family]
        List of families with siblings.
    family_next_rank : Dict[int, int]
        Mapping of family IDs to their next rank of daycare preference.
    Pi_set : List[List[int]]
        Set of permutations that have been already checked.
    already_matched_family : List[Family]
        List of families already matched.
    child_next_rank : Dict[int, int]
        Mapping of child IDs to their next daycare preference rank.
    Algorithm_terminated : bool
        Flag indicating if the algorithm has terminated.
    B_total : List[Child]
        List of all children to be reassigned.

    Returns:
    -------
    Tuple[bool, bool, bool, List[int], List[List[int]], List[Child]]
        A tuple containing flags and updated structures indicating the state of the algorithm
        and next actions to be taken.
    """
    pi_is_changed: bool = False
    family = having_siblings_families[pi_i]
    family_next_rank[family.id] = 0
    B_set = []

    go_next_step_bool = True
    new_pi = pi.copy()

    done = False
    while not done:
        done = True
        if family.assignment != None:
            break
        if family_next_rank[family.id] >= len(family.pref):
            break
        done = False

        daycare_tuple = family.pref[family_next_rank[family.id]]

        family_children_pref_dict = {}
        for i in range(len(family.children)):
            family_children_pref_dict[family.children[i]] = daycare_tuple[i]

        accepted, rejected_children_all, new_daycare_match_dict = choice_function_for_family(family_children_pref_dict)

        if accepted == 0: # Application is accepted
            former_families_under_pi = []
            for i in pi:
                if having_siblings_families[i] == family:
                    break
                else:
                    former_families_under_pi.append(having_siblings_families[i])

            evict_another_family_with_siblings = 0
            for c1 in rejected_children_all:
                for ff in former_families_under_pi:
                    for c2 in ff.children:
                        if c1==c2:
                            evict_another_family_with_siblings+=1
                            evicted_family = ff
                            break

            if evict_another_family_with_siblings != 0:
                j = pi.index(having_siblings_families.index(evicted_family))
                i = pi.index(pi_i)
                pi_prime = update_pi(pi,j,i)
                if pi_prime in Pi_set:
                    Algorithm_terminated = True
                    break
                else:
                    Pi_set.append(pi_prime)
                    new_pi = pi_prime
                    pi_is_changed = True
                    break
            else:
                family.assignment = family_next_rank[family.id]
                # Update matching
                for c in family.children:
                    c.assigned_daycare = family_children_pref_dict[c]
                for d in new_daycare_match_dict:
                    d.assigned_children = new_daycare_match_dict[d]
                for c in rejected_children_all:
                    c.assigned_daycare = None
                already_matched_family.append(family)
                B_set += rejected_children_all

                # --------------STEP 3---------------

                B_total += B_set
                B_total = list(set(B_total))
                while len(B_total) != 0:

                    go_next_step_bool = False

                    for child_0 in B_total:
                        if child_0.assigned_daycare != None:
                            child_0.assigned_daycare.assigned_children[child_0.age].remove(child_0)
                            child_0.assigned_daycare = None

                    for child_0 in B_total:
                        B_total.remove(child_0)
                        child_next_rank[child_0.id] = 0
                        done = False
                        while not done:
                            done = True
                            if child_0.assigned_daycare != None:
                                break
                            if child_next_rank[child_0.id] >= len(child_0.pref):
                                child_0.assigned_daycare = None
                                break
                            done = False
                            rejected_child = choice_function_for_child(
                                child_0, 
                                child_next_rank
                                )
                            if rejected_child == None:

                                # Update matching
                                child_0.assigned_daycare = child_0.pref[child_next_rank[child_0.id]]
                                child_0.pref[child_next_rank[child_0.id]].assigned_children[child_0.age].append(child_0)
                                child_next_rank[child_0.id] += 1
                            else:
                                if rejected_child == child_0:
                                    child_next_rank[child_0.id] += 1
                                else:
                                    # If the rejected child is not child_0, then check two scenarios:
                                    # (1) whether the rejected child belongs to the currently considered family with siblings (identified in having_siblings_families[pi_i]),
                                    # (2) whether the rejected child belongs to a family with siblings that has already submitted an application earlier.

                                    # (1)   
                                    evict_same_family_with_siblings = 0
                                    for c_1 in family.children:
                                        if rejected_child==c_1:
                                            evict_same_family_with_siblings +=1
                                            break
                                    if evict_same_family_with_siblings != 0:
                                        Algorithm_terminated = True
                                        break

                                    # (2) 
                                    evict_another_family_with_siblings_2 = 0
                                    for ff in former_families_under_pi:
                                        for c2_2 in ff.children:
                                            if rejected_child==c2_2:
                                                evict_another_family_with_siblings_2 += 1
                                                evicted_family_2 = ff
                                                break
                                    
                                    if evict_another_family_with_siblings_2 != 0:
                                        j_2 = pi.index(having_siblings_families.index(evicted_family_2))
                                        i_2 = pi.index(pi_i)
                                        pi_prime_2 = update_pi(pi,j_2,i_2)                                 
                                        if pi_prime_2 in Pi_set:
                                            Algorithm_terminated = True
                                            break
                                        else:
                                            Pi_set.append(pi_prime_2)
                                            new_pi = pi_prime_2
                                            pi_is_changed = True
                                            break
                                    else:
                                        B_set.append(rejected_child)

                                        # Update matching
                                        rejected_child.assigned_daycare = None
                                        child_0.assigned_daycare = child_0.pref[child_next_rank[child_0.id]]
                                        child_0.pref[child_next_rank[child_0.id]].assigned_children[child_0.age].remove(rejected_child)

                                        child_0.pref[child_next_rank[child_0.id]].assigned_children[child_0.age].append(child_0)
                                        child_next_rank[child_0.id] += 1
                        if Algorithm_terminated == True:
                            break
                        if pi_is_changed == True:
                            break
                    if Algorithm_terminated == True:
                        break
                    if pi_is_changed == True:
                        break
                if Algorithm_terminated == True:
                    break
                if pi_is_changed == True:
                    break
        if accepted > 0:
            family_next_rank[family.id] += 1
        
        if go_next_step_bool != True:
            family.assignment = None

            for c in family.children:
                c.assigned_daycare.assigned_children[c.age].remove(c)
                c.assigned_daycare = None
 
    return go_next_step_bool, pi_is_changed, Algorithm_terminated, new_pi, Pi_set, B_set


def SDA_matching(
        children: List[SDA_Child], 
        daycares: List[SDA_Daycare], 
        no_siblings_children: List[SDA_Child], 
        having_siblings_families: List[SDA_Family], 
        families: List[SDA_Family]
    ) -> Tuple[
        List[int], 
        bool
    ]:
    """
    Implement the SDA algorithm.

    Parameters:
    - children: List[Child] - A list of Child instances.
    - daycares: List[Daycare] - A list of Daycare instances.
    - no_siblings_children: List[Child] - A list of Child instances without siblings.
    - having_siblings_families: List[Family] - A list of Family instances with siblings.
    - families: List[Family] - A list of all Family instances.

    Returns:
    - Tuple[List[int], bool]: A tuple containing the final permutation of families without siblings, and a boolean indicating if the algorithm succeeded.
    """
    
    succeed: bool = False
    Pi_set: List[List[int]] = [] # List of permutations that have been checked
    pi: List[int] = [i for i in range(len(having_siblings_families))]
    Pi_set.append(pi)

    Algorithm_terminated: bool = False

    while not Algorithm_terminated:
        
        # --------------STEP 1---------------

        # Initilize
        for daycare in daycares:
            daycare.assigned_children = [[] for _ in range(6)]
        for child in children:
            child.assigned_daycare = None

        child_next_rank = dict()
        for child in children:
            child_next_rank[child.id] = 0

        child_next_rank = children_propose_da(no_siblings_children, daycares, child_next_rank)

        for family in having_siblings_families:
            family.assignment = None
    
        family_next_rank = dict()
        for family in having_siblings_families:
            family_next_rank[family.id] = 0

        alreafy_matched_family = []

        # --------------STEP 2---------------

        pi_index = 0
        B_total = []
        while True:
            pi_i = pi[pi_index]
            
            go_next_step_bool, pi_is_changed, Algorithm_terminated, new_pi, Pi_set, B_total = whether_go_next_step(pi, pi_i, having_siblings_families, family_next_rank, Pi_set, alreafy_matched_family, child_next_rank, Algorithm_terminated, B_total)

            if Algorithm_terminated == True:
                # print("Algorithm failed!!")
                break
            if pi_is_changed == True:
                pi = new_pi.copy()
                break

            if go_next_step_bool == True:
                B_total = []
                pi_index += 1

            if pi_i == pi[-1]:
                Algorithm_terminated = True
                succeed = True
                # print("Algorithm succeeded!!")
                break
        

        if pi_is_changed == True:
            pass
        if Algorithm_terminated == True:
            break
    return pi, succeed


