import copy
import time
from typing import Dict, List, Any, Tuple, Optional
from initialization.agent_Class import SDA_Child


def choice_function_for_child(
        child_0: SDA_Child, 
        child_next_rank: Dict[int, int]
    ) -> Optional[SDA_Child]:
    
    """
    Determines whether the child's application to the next preferred daycare is accepted 
    and identifies any child that would be displaced by this application.

    Parameters:
    ----------
    child_0 : Child
        The child object currently being considered.
    child_next_rank : dict
        A dictionary mapping child IDs to the index of the next daycare in their preference list to apply to.

    Returns:
    -------
    Optional[Child]
        The child object that would be displaced by the application, if any, otherwise None.
    """

    daycare = child_0.pref[child_next_rank[child_0.id]]
    age = child_0.age
    merged_list = [child_0]+ daycare.assigned_children[age]

    if len(merged_list) > daycare.total_numbers[age]:
        merged_list.sort(key=lambda c: daycare.priority.index(c))
        rejected_child = merged_list[-1]
    else:
        rejected_child = None

    return rejected_child