import copy
import time
from typing import Dict, List, Any, Tuple, Optional

from initialization.agent_Class import SDA_Child, SDA_Family, SDA_Daycare



from main.SDA_matching import SDA_matching


def make_no_siblings_families_list(
        families: List[SDA_Family]
    ) -> Tuple[
        List[SDA_Child],
        List[SDA_Family]
    ]:
    """
    Output 
    (i) the set of children which do not have siblings
    (ii) the set of families which have siblings
    """
    no_siblings_families: List[SDA_Family] = []
    for f in families:
        if f.has_siblings == False:
            no_siblings_families.append(f)

    no_siblings_children: List[SDA_Child] = []
    for f in no_siblings_families:
        no_siblings_children += f.children

    having_siblings_families: List[SDA_Family] = []
    for f in families:
        if not f in no_siblings_families:
            having_siblings_families.append(f)
    
    return no_siblings_children, having_siblings_families



def implement_SDA(
        children: List[SDA_Child], 
        daycares: List[SDA_Daycare], 
        families: List[SDA_Family]
    ) -> Tuple[
        List[int], 
        bool
    ]:          

    no_siblings_children, having_siblings_families = make_no_siblings_families_list(families)

    # time_sta = time.time() 
    pi, succeed  = SDA_matching(children, daycares, no_siblings_children, having_siblings_families, families)
    # time_end = time.time()        
    # tim = time_end - time_sta  
    # print("time:",tim)
    return pi, succeed