import copy
import numpy as np
import os 
import pickle
import sys
from typing import Dict, DefaultDict, List, Any, Tuple, Optional

from initialization.setup_inputs import SDA_Child, SDA_Daycare

def check_feasibility(
        children: List[SDA_Child], 
        daycares: List[SDA_Daycare]
    ):

    """
    check whether each daycare admits more children than its capacity
    """
    count = 0
    
    outcome = dict()
    for d in daycares:
        outcome[d.id] = [0 for i in range(6)]
    for c in children:
        if c.assigned_daycare != None:
            outcome[c.assigned_daycare.id][c.age] += 1
    for d in daycares:
        for age in range(6):
            if outcome[d.id][age] > d.total_numbers[age]:
                count += 1
                print("Wrong!", d, 'age', age)
                print('# of matched children', outcome[d.id][age], 'capacity', d.total_numbers[age])
   
    if count == 0:
        print("Daycare capacities are not exceeded.")
    
    count_2 = 0
    outcome_2 = dict()
    for d in daycares:
        outcome_2[d.id] = [[] for i in range(6)]
    for c in children:
        if c.assigned_daycare != None:
            outcome_2[c.assigned_daycare.id][c.age].append(c)
    for d in daycares:
        for age in range(6):
            if set(outcome_2[d.id][age]) != set(d.assigned_children[age]):
                print(outcome_2[d.id][age])
                print(d.assigned_children[age])
                count_2 += 1
                print("Wrong!", d, 'age', age)
    if count_2 == 0:
        print("The number of matched children and the number of children matched to daycares are all consistent.")



def check_children_initial_enrollment(
        children: List[SDA_Child]
    ):
    """
    for each child c with initial enrollemnt, check whether he is matched to some daycare
    """
    initial = 0
    unmatched = []
    for c in children:
        if c.initial_daycare != 9999:
            initial += 1
            if c.assigned_daycare == None:
                unmatched.append(c)
                print("c=",c)
                
            
    if len(unmatched) == 0:
        print('All children wishing to transfer are matched.')
    else:
        print(len(unmatched), "out of", initial ,"children with initial enrollment are unmatched.")   


