
import pickle
from typing import Dict, DefaultDict, List, Any, Tuple, Optional

from utils.get_agent import get_agent

# 安定性の確認のため，以下のCPフォルダで定義された関数を利用する
# src/daycarematching/cp/helper_functions.py

# ただし, setup.pyをもとにpip install -e .でdaycarematchingをimportすれば, 
# from daycarematching.cp.helper_functions import create_agents as CP_create_agents, check_outcome as CP_check_outcome
# で良い
######
import sys
import os
current_dir = os.path.dirname(os.path.abspath(__file__))
# print(current_dir)
target_dir = os.path.join(current_dir.replace("SoDA/utils",""))
sys.path.insert(0, target_dir)
# print(sys.path)
from cp.helper_functions import create_agents as CP_create_agents, check_outcome as CP_check_outcome
######

def check_stability(
        children_dic: DefaultDict[int, DefaultDict[str, Any]], 
        daycares_dic: DefaultDict[int, DefaultDict[str, Any]], 
        families_dic: DefaultDict[int, DefaultDict[str, Any]], 
        pkl_filename: str
    ):

    children, daycares, families = CP_create_agents(children_dic, daycares_dic, families_dic)
    sda_outcome = pickle.load(open(pkl_filename, "rb"))
    # convert the format of soda_outcome 

    outcome_f = {}
    for f in families:
        for p in range(len(f.pref)):
            outcome_f[f.id, p] = 0
            
        if sda_outcome[f.id] == None:
            sda_outcome[f.id] = len(f.pref)
        outcome_f[f.id, sda_outcome[f.id]] = 1


    outcome_children_dic={}
    for c in children:
        outcome_children_dic[c.id] = {}
        f = get_agent(c.family, families)
        if sda_outcome[f.id] < len(c.projected_pref):
            outcome_children_dic[c.id]['CP'] = c.projected_pref[ sda_outcome[f.id] ]
            c.assigned_daycare = c.projected_pref[ sda_outcome[f.id] ]
        else:
            outcome_children_dic[c.id]['CP'] = 9999
            c.assigned_daycare = 9999

    non_IR_children, infeasible_daycare_ids, bp_dic = CP_check_outcome(children_dic, daycares_dic, families_dic, outcome_children_dic, outcome_f, share_bool = False)

    # number of matched children by age
    outcome_daycares = {}
    for d in daycares:
        outcome_daycares[d.id] = [0 for g in range(6)]  
        
    for c in children:
        if c.assigned_daycare != None:
            if c.assigned_daycare == 11003 and c.age ==5:
                print(c, c.family, sda_outcome[c.family], c.pref)
            outcome_daycares[c.assigned_daycare][c.age] += 1
            
    for did in infeasible_daycare_ids:
    #     print(did)
        d = get_agent(did, daycares)
        for g in range(6):
            if outcome_daycares[d.id][g] > d.total_numbers[g]:
                print('outcome_daycares[{}][{}]'.format(d.id, g), outcome_daycares[d.id][g], 'd.total_numbers[{}]'.format(g),d.total_numbers[g])
                