from collections import defaultdict
from typing import Dict, DefaultDict, List, Any, Tuple, Optional

from initialization.setup_inputs import SDA_Child, SDA_Daycare, SDA_Family


def count_match(
        children: List[SDA_Child], 
        families: List[SDA_Family], 
        daycares: List[SDA_Daycare]
    ) -> Tuple[
        DefaultDict[int, Tuple[int]],
        int
    ]:

    outcome = defaultdict()
    for d in daycares:
        outcome[d.id] = [0 for i in range(6)]
    for c in children:
        if c.assigned_daycare != None:
            outcome[c.assigned_daycare.id][c.age] += 1

    for f in families:
        if f.has_siblings == False: 
            c = f.children[0]
            if c.assigned_daycare != None:
                f.assignment = c.pref.index(c.assigned_daycare)
            else:
                f.assignment = len(c.pref)


    for f in families:
        if f.has_siblings == False: 
            c = f.children[0]
            if c.assigned_daycare != None:
                f.assignment = c.pref.index(c.assigned_daycare)
            else:
                f.assignment = len(c.pref)
        else:
            if f.assignment == None:
                f.assignment = len(f.pref)

    dic: DefaultDict[Tuple[int]] = defaultdict()
    for f in families:
        dic[f.id]= f.assignment
    


    num_of_match_chil=0
    for c in children:
        #print(c.assigned_daycare)
        if c.assigned_daycare != None:
            if c.assigned_daycare.id != 9999:
                num_of_match_chil+=1

    # print("The number of children who match:", num_of_match_chil, "out of", len(children))

    return dic, num_of_match_chil


