# HyperSINDy
This repository is the official implementation of [HyperSINDy: Deep Generative Modeling of Nonlinear Stochastic Governing Equations](). 


## Requirements
All the requirements are contained in the environment.yml file
To install the requirements, run:
```
conda env create -f environment.yml
```

Then, activate the conda environment:
```
conda activate hypersindy
```

## Pre-trained Models
Pre-trained models are located in the pretrained_models folder.
To use them, copy everything from pretrained_models into runs:
```
cp -r pretrained_models/* runs/
```
This is the recommended approach, since you will not have to retrain all the models.
Alternatively, the scripts can be modified to load from the pretrained_models directory instead of
the runs directory, but this requires more code modifications (changing runs/cp_* to
pretrained_models/cp_* in multiple code files).


## Data Generation
To generate the data in the paper, run these commands:
```
cd scripts
python3 generate_lorenz.py
python3 generate_rossler.py
python3 generate_lotkavolterra.py
python3 generate_lorenz96.py
python3 generate_lorenz_rmse.py
python3 generate_rossler_rmse.py
```


## Experiments
# Tensorboard
The training progress of HyperSINDy models can be viewed using tensorboard.
Open a separate terminal window and make sure the current directory is the base of the repository.
Then, run:
```
tensorboard --logdir="runs/"
```

# Note
To run any script, we assume you are in the "scripts" folder.

# Figure 2
Training:
```
python3 train_lorenz.py --s1 1
python3 train_lorenz.py --s2 1
python3 train_lorenz.py --s3 1
python3 train_rossler.py --s1 1
python3 train_rossler.py --s2 1
python3 train_rossler.py --s3 1
```

Results:
```
python3 fig2a.py
python3 fig2b.py
```

# Figure 3
Training:
```
python3 train_lotkavolterra.py --s1 1
python3 train_ss_lotkavolterra.py
```
Note that train_ss_lotkavolterra outputs the equations to results/ss_lotkavolterra.txt.
We manually implement those equations in generate_ss_lotkavolterra.py.

Results:
```
python3 generate_ss_lotkavolterra.py
python3 fig3.py
```

# Figure 4
Training:
```
python3 train_lorenz96.py --s1 1
```

Results:
```
python3 fig4a.py
python3 fig4b.py
```

# Table 1
Training:
```
python3 train_lorenz_rmse.py --s1 1
python3 train_lorenz_rmse.py --s2 1
python3 train_lorenz_rmse.py --s3 1
python3 train_rossler_rmse.py --s1 1
python3 train_rossler_rmse.py --s2 1
python3 train_rossler_rmse.py --s3 1
```

In addition, the following notebooks will have to be run from start to finish to generate the E-SINDy models.
These notebooks can be run directly from the notebooks folder.
```
lorenz_rmse_esindy.ipynb
rossler_rmse_esindy.ipynb
```

Results:
To generate the results, run the following notebooks from start to finish.
These notebooks can be run directly from the notebooks folder.
```
lorenz_rmse.ipynb
rossler_rmse.ipynb
```

# Appendix
To generate the results for the appendix figures, run these commands:
```
python3 appendix_lorenz.py
python3 appendix_rossler.py
python3 appendix_lorenz_true.py
python3 appendix_rossler.py
python3 appendix_lorenz96.py
python3 appendix_esindy_lorenz.py
python3 appendix_esindy_rossler.py
```

Note that the notebooks folder contains .ipynb versions of some of these results-generating scripts.