# Confidence Adaptive Regularization for Deep Learning with Noisy Labels

This repository is the official implementation of Confidence Adaptive Regularization for Deep Learning with Noisy Labels.

Recent studies on the memorization effects of deep neural networks on noisy labels show that they first fit the correctly-labeled training samples before memorizing the mislabeled samples. Motivated by this early-learning phenomenon, we propose a novel method to prevent memorization of the mislabeled samples. Unlike the existing approaches that use the model output to identify or ignore the mislabeled samples, we introduce an indicator branch to the original model and make the model produce a confidence value for each sample. The confidence values are incorporated in our loss function that is learned to assign large confidence values for correctly-labeled samples and small confidence values for mislabeled samples. We also propose an auxiliary regularization term to further improve the robustness of the model. To improve the performance, we gradually correct the noisy labels with a well-designed target estimation strategy. We provide the theoretical analysis and conduct the experiments on synthetic and real-world datasets, demonstrating that our approach achieves comparable results to the state-of-the-art methods.

## Requirements

This codebase is written for `python3`, other necessary python packages are including

- numpy=1.20.1
- torch=1.8.1
- torchvision=0.2.2
- Pillow=8.2.0

## Training

### Usage
To train the model in the paper, run the following commands:
#### Datasets with synthetic label noise
Train the network on the CIFAR-10 dataset with 60% symmmetric label noise:
```train
python train_cifar.py --root_dir <path_to_save_data> --noise_mode 'sym' --r 0.6 
```
Train the network on the CIFAR-10 dataset with 40% asymmmetric label noise :
```train
python train_cifar.py --root_dir <path_to_save_data> --noise_mode 'asym' --r 0.4 --num_epochs 300 
```
Train the network on the CIFAR-100 dataset with 60% symmmetric label noise :
```train
python train_cifar.py --root_dir <path_to_save_data> --dataset 'cifar100' --noise_mode 'sym' --r 0.6 --lam 10 --beta 0.1 --delta 0.95
```

Please refer to the Appendix D.4 for more information of hyperparameters.
```
hyperparameter options:
--batch_size            batch size
--lr                    learning rate
--num_epochs            number of epochs
--noise_mode            label noise model(e.g. sym, asym)
--r                     noise level (e.g. 0.4)
--lam                   penalty loss coefficient
--delta                 confidence threshold
--beta                  auxiliary regularization coefficient
--m                     momentum for target estimation
--es                    epoch that starts to perform target estimation
```

#### Datasets with real-world label noise

Before running the code, please download the dataset [Clothing1M](https://github.com/Cysu/noisy_label) and [Webvision](https://data.vision.ee.ethz.ch/cvl/webvision/dataset2017.html).

Train the network on the Clothing1M:
```train
python train_clothing1m.py --root_dir <path_to_data>
```

Train the network on the Webvision:

```train
python train_webvision.py --root_dir <path_to_data>
```

## Results

Our model achieves the following performance:

### Test accuracy (%) on CIFAR10 


| Method                 |  20%  Sym      |    40%  Sym    |   60%  Sym      |      80%  Sym  |    40% Asym |
| ---------------------- | ----------- | ----------- | -----------  | ----------- | ----------- |
| CAR                    | 94.37%      | 93.49%      |  90.56%      | 80.98%      |     92.09%  |

### Test accuracy (%) on CIFAR100 
| Method                 |  20%  Sym      |    40%  Sym    |   60%  Sym      |      80%  Sym  |    40% Asym |
| ---------------------- | ----------- | ----------- | -----------  | ----------- | ----------- |
| CAR                    | 77.90%      | 75.38%      |  69.78%      | 38.24%      |     74.89%  |


## Contributing

- This README is formatted based on [paperswithcode](https://github.com/paperswithcode/releasing-research-code).
