import argparse
import glob2
import pandas as pd


def summary(args):
    input_folders = args.input_folders.split(",")
    results = {}
    datatsets = {"Experiment": []}
    for input_folder in input_folders:
        files = glob2.glob(input_folder + "/" + "score.txt")
        for file in files:
            print(file)
            experiment = file.split("/")[-2]
            print(experiment)
            results[experiment] = {}
            with open(file) as f:
                lines = f.readlines()
                for line in lines:
                    if "Final" in line:
                        splits = line.split()
                        dataset = splits[3]
                        score = float(splits[4])
                        results[experiment][dataset] = score
                        datatsets[dataset] = []
    for k, v in results.items():
        datatsets["Experiment"].append(k)
        print(k)
        for x, y in datatsets.items():
            if x == 'Experiment':
                continue
            if x in v:
                datatsets[x].append(v[x])
            else:
                datatsets[x].append(None)
    df = pd.DataFrame.from_dict(datatsets)
    return df


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='TDC Admet result summary')
    parser.add_argument("--input_folders", default="./", type=str,
                        help='Input folders, separated by commas')

    args = parser.parse_args()
    df = summary(args)
    df.to_csv("./summary.csv", index=False)
