# Single-Task Attack
MODELS=("meta-llama/LlamaGuard-7b" "meta-llama/Meta-Llama-Guard-2-8B" "meta-llama/Llama-Guard-3-8B" "lmsys/vicuna-7b-v1.5")
MODEL_NAME=("LlamaGuard-7b" "Meta-Llama-Guard-2-8B" "Llama-Guard-3-8B" "Vicuna-7b")
ATTACK_POS="suffix"
VOCAB_CHECK="None"
NUM_CASES=20
NUM_UNIVERSAL=12
NUM_STEPS=50
TEST_UNIVERSAL=200
OUTPUT_DIR="experiments"


for model_idx in "${!MODELS[@]}"; do
    model_path="${MODELS[$model_idx]}"
    model_name="${MODEL_NAME[$model_idx]}"
    
    LOG_FILE="${OUTPUT_DIR}/${model_name}/single-task_${VOCAB_CHECK}_${ATTACK_POS}/log.log"
    OUTPUT_FILE="${OUTPUT_DIR}/${model_name}/single-task_${VOCAB_CHECK}_${ATTACK_POS}/result.jsonl"
    
    mkdir -p "$(dirname "$LOG_FILE")"
    mkdir -p "$(dirname "$OUTPUT_FILE")"

    echo "Running universal adversarial attack with the following configuration:"
    echo "Model Path: ${model_path}"
    echo "Model Name: ${model_name}"
    echo "Attack Position: ${ATTACK_POS}"
    echo "Log File: ${LOG_FILE}"
    echo "Output File: ${OUTPUT_FILE}"
    echo "Number of Cases: ${NUM_CASES}"
    echo "Number of Universal Prompts: ${NUM_UNIVERSAL}"
    echo "Number of Steps: ${NUM_STEPS}"
    echo "Number of Test Universal Prompts: ${TEST_UNIVERSAL}"
    echo "Vocab Check Level: ${VOCAB_CHECK}"

    python scripts/single_task_attack.py \
        --model_name "${model_path}" \
        --log_file_name "${LOG_FILE}" \
        --attack_pos "${ATTACK_POS}" \
        --output_file "${OUTPUT_FILE}" \
        --num_cases "${NUM_CASES}" \
        --num_universal "${NUM_UNIVERSAL}" \
        --num_steps "${NUM_STEPS}" \
        --test_universal "${TEST_UNIVERSAL}" \
        --vocab_check "${VOCAB_CHECK}"
done


# Multi-Task Attack
MODELS=("meta-llama/Meta-Llama-Guard-2-8B" "meta-llama/LlamaGuard-7b" "meta-llama/Llama-Guard-3-8B" "lmsys/vicuna-7b-v1.5")
MODEL_NAME=("Meta-Llama-Guard-2-8B" "LlamaGuard-7b" "Llama-Guard-3-8B" "Vicuna-7b")
ATTACK_POS=("suffix" "prefix" "random")
VOCAB_CHECK="None"
NUM_CASES=20
NUM_UNIVERSAL=12
NUM_STEPS=50
TEST_UNIVERSAL=200


for model_idx in "${!MODELS[@]}"; do
    for attack_pos in "${ATTACK_POS[@]}"; do
        model_name="${MODEL_NAME[$model_idx]}"
        model_path="${MODELS[$model_idx]}"
        
        LOG_FILE="${OUTPUT_DIR}/${model_name}/multi-task_${VOCAB_CHECK}_${attack_pos}/log.log"
        OUTPUT_FILE="${OUTPUT_DIR}/${model_name}/multi-task_${VOCAB_CHECK}_${attack_pos}/result.jsonl"
        
        mkdir -p "$(dirname "$LOG_FILE")"
        mkdir -p "$(dirname "$OUTPUT_FILE")"

        echo "Running universal adversarial attack with the following configuration:"
        echo "Model Path: ${model_path}"
        echo "Model Name: ${model_name}"
        echo "Attack Position: ${attack_pos}"
        echo "Log File: ${LOG_FILE}"
        echo "Output File: ${OUTPUT_FILE}"
        echo "Number of Cases: ${NUM_CASES}"
        echo "Number of Universal Prompts: ${NUM_UNIVERSAL}"
        echo "Number of Steps: ${NUM_STEPS}"
        echo "Number of Test Universal Prompts: ${TEST_UNIVERSAL}"
        echo "Vocab Check Level: ${VOCAB_CHECK}"

        python scripts/multi_task_attack.py \
            --model_name "${model_path}" \
            --log_file_name "${LOG_FILE}" \
            --attack_pos "${attack_pos}" \
            --output_file "${OUTPUT_FILE}" \
            --num_cases "${NUM_CASES}" \
            --num_universal "${NUM_UNIVERSAL}" \
            --num_steps "${NUM_STEPS}" \
            --test_universal "${TEST_UNIVERSAL}" \
            --vocab_check "${VOCAB_CHECK}"
    done
done

#Different vocab check levels
MODELS=("meta-llama/Llama-Guard-3-8B" "lmsys/vicuna-7b-v1.5")
MODEL_NAME=("Llama-Guard-3-8B" "Vicuna-7b")
ATTACK_POS=("suffix" "prefix" "random")
VOCAB_CHECK=("None" "Moderate" "Strict")
NUM_CASES=20
NUM_UNIVERSAL=12
NUM_STEPS=50
TEST_UNIVERSAL=200


for model_idx in "${!MODELS[@]}"; do
    for attack_pos in "${ATTACK_POS[@]}"; do
        for vocab_check in "${VOCAB_CHECK[@]}"; do
            model_name="${MODEL_NAME[$model_idx]}"
            model_path="${MODELS[$model_idx]}"
            
            LOG_FILE="${OUTPUT_DIR}/${model_name}/multi-task_${vocab_check}_${attack_pos}/log.log"
            OUTPUT_FILE="${OUTPUT_DIR}/${model_name}/multi-task_${vocab_check}_${attack_pos}/result.jsonl"
            
            mkdir -p "$(dirname "$LOG_FILE")"
            mkdir -p "$(dirname "$OUTPUT_FILE")"

            echo "Running universal adversarial attack with the following configuration:"
            echo "Model Path: ${model_path}"
            echo "Model Name: ${model_name}"
            echo "Attack Position: ${attack_pos}"
            echo "Log File: ${LOG_FILE}"
            echo "Output File: ${OUTPUT_FILE}"
            echo "Number of Cases: ${NUM_CASES}"
            echo "Number of Universal Prompts: ${NUM_UNIVERSAL}"
            echo "Number of Steps: ${NUM_STEPS}"
            echo "Number of Test Universal Prompts: ${TEST_UNIVERSAL}"
            echo "Vocab Check Level: ${vocab_check}"

            python scripts/multi_task_attack.py \
                --model_name "${model_path}" \
                --log_file_name "${LOG_FILE}" \
                --attack_pos "${attack_pos}" \
                --output_file "${OUTPUT_FILE}" \
                --num_cases "${NUM_CASES}" \
                --num_universal "${NUM_UNIVERSAL}" \
                --num_steps "${NUM_STEPS}" \
                --test_universal "${TEST_UNIVERSAL}" \
                --vocab_check "${vocab_check}"
        done
    done
done