classdef (Abstract) nnGNNLayer < nnLayer
% nnGNNLayer - abstract class for nn layers
%
% Syntax:
%    layer = nnGNNLayer(name)
%
% Inputs:
%    name - name of the layer, defaults to type
%
% Outputs:
%    obj - generated object
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: validateNNoptions, options.nn.graph

% ------------------------------ BEGIN CODE -------------------------------

methods
    function obj = nnGNNLayer(varargin)
        obj@nnLayer(varargin{:})
        obj.inputSize = [];
    end
end

methods (Abstract)
    [nin, nout] = getNumNeurons(obj, graph)
    outputSize = getOutputSize(obj, inputSize, graph)
end

end

% ------------------------------ END OF CODE ------------------------------
