function v = vecleftmtimes(A,v)
% function - left mtimes for a vectorized matrix
%
% Syntax:
%    v = vecleftmtimes(A,v,n,k,m)
%
% Inputs:
%    A - numeric matrix (n x k)
%    v - nectorized matrix (k*m x h)
%
% Outputs:
%    v - vectorized result
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       Tobias Ladner
% Written:       16-April-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% init dimensions
[n,k] = size(A);
[km,h] = size(v);
m = km/k;

% reshape vectorized matrix back to matrix
M = reshape(v,k,m,h);

% do matrix multiplication (including broadcasting)
M = pagemtimes(A,M);

% reshape back to vector
v = reshape(M,n*m,h);

end
