function v = vecrightmtimes(v,A)
% function - right mtimes for a vectorized matrix
%
% Syntax:
%    v = vecleftmtimes(A,v,n,k,m)
%
% Inputs:
%    v - nectorized matrix (n*k x h)
%    A - numeric matrix (k x m)
%
% Outputs:
%    v - vectorized result
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       Tobias Ladner
% Written:       16-April-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% init dimensions
[nk,h] = size(v);
[k,m] = size(A);
n = nk/k;

% reshape vectorized matrix back to matrix
M = reshape(v,n,k,h);

% do matrix multiplication (including broadcasting)
M = pagemtimes(M,A);

% reshape back to vector
v = reshape(M,n*m,h);

end
