#!/bin/bash

DEFAULT_NAME=cora-xai-mnist
MAIN_SCRIPT=gnn_main

docker build . -t "$DEFAULT_NAME" --no-cache
# Option 1: license server
docker run  -e MLM_LICENSE_FILE=<port>@<url> --name "$DEFAULT_NAME" "$DEFAULT_NAME" -batch "cd /code; addpath(genpath('.')); $MAIN_SCRIPT"
# Option 2: license file
# docker run --mac-address 02:42:ac:11:00:0a -e MLM_LICENSE_FILE=/home/matlab/Documents/MATLAB/license.lic --name "$DEFAULT_NAME" "$DEFAULT_NAME" -batch "cd /; addpath(genpath('/code')); $MAIN_SCRIPT"
docker cp "$DEFAULT_NAME":/code/results .
docker rm --force "$DEFAULT_NAME"
docker image rm --force "$DEFAULT_NAME"

