function gnn_example_invsqrtroot()
% gnn_example_invsqrtroot - example for neural network enclosure
%    of an inv sqrt layer using regression
%
% Syntax:
%    gnn_example_invsqrtroot()
%
% Inputs:
%    -
%
% Outputs:
%    res - boolean 

% ------------------------------ BEGIN CODE -------------------------------

% init
l = 2;
u = 5;
order = 1;

l_max = l-1;
u_max = 9;

layer = nnInvSqrtRootLayer();

% plot
figure; hold on;

% plot f(x)
x_max = linspace(l_max, u_max);
y_max = layer.f(x_max);
plot(x_max, y_max, 'k', 'DisplayName', "Inverse square root x^{-1/2}")

x = linspace(l, u);

% compute enclosure
[coeffs, d] = layer.computeApproxPoly(l, u, order, 'regression');
y_p = polyval(coeffs, x);

% plot incl. bounds
color = [0.46600,0.67400,0.18800];
plot(x, y_p, "Color", color, 'DisplayName', 'Approx. polynomial p(x)');
plot(x, y_p-d, '--', "Color", color, 'HandleVisibility', 'off');
plot(x, y_p+d, '--', "Color", color, 'HandleVisibility', 'off');

% plot error
x0 = 3.3131;
y0 = layer.f(x0);
plot([x0,x0],[y0,y0+d],'r','DisplayName','Approx. error d');

% plot [l, u] limits
gray = ones(1, 3) * 0.7;
plot([l,l],ylim, '--', "Color", gray, 'HandleVisibility', 'off')
plot([u,u],ylim, '--', "Color", gray, 'HandleVisibility', 'off')

% plot legends
legend()

end

% ------------------------------ END OF CODE ------------------------------
