function gnn_example_quadMap
% gnn_example_quadMap - example polyZonotope/quadMap
%
% Syntax:
%    gnn_example_quadMap()
%
% Inputs:
%    -
%
% Outputs:
%    res - boolean

% ------------------------------ BEGIN CODE -------------------------------

% init polyZonotope
c = [0;0;0];
G = [1 0 0 0;0 1 0.1 0; 0 0 0 1];
E = [1 3 0 2; 0 0 1 0];
pZ = polyZonotope(c,G,[],E);

% sample points
N = 100;
xs = [randPoint(pZ,N*3/4),randPoint(pZ,N*1/4,'extreme')];

% init Q
Q{1} = [0 0 1; 0 0 0; 0 0 0];
Q{2} = [0 0 0; 0 1 0; 0 0 0];

% compute quadratic map on pZ and points
pZquad = quadMap(pZ,Q);
xsquad = zeros(length(Q),N);
for i=1:N
    xsquad(:,i) = [xs(:,i)'*Q{1}*xs(:,i);xs(:,i)'*Q{2}*xs(:,i)];
end

% plot
figure;
subplot(1,2,1); hold on;
plot(pZ,[1,2],'DisplayName','PZ');
plot(xs(1,:),xs(2,:),'.k','DisplayName','Samples')
enlargeAxis(1.2)
legend

subplot(1,2,2); hold on;
plot(pZquad,[1,2],'DisplayName','quad(PZ)');
plot(xsquad(1,:),xsquad(2,:),'.k','DisplayName','Samples')
enlargeAxis(1.2)
legend

% ------------------------------ END OF CODE ------------------------------
