# Parameters
import numpy as np
from scipy.stats import bernoulli

from comab.algo.osub import I
from comab.environment import CoMABEnv

N = 100
K = 1
p = np.arange(K, dtype=int) + 4
P = max(p)
F = [bernoulli(p=0.05) for k in range(K)]
env = CoMABEnv(p, F, N)

np.set_printoptions(precision=6)
print("Optimal arm:", env.n_star)
print("Optimal reward:", env.r_star)
rewards = np.array([env.r(np.array([_n])) for _n in range(N+1)])
max_reward = max(rewards)
Delta_KL = (I(np.sort(rewards)[-2], max_reward))/(max_reward - np.sort(rewards)[-2])
Delta_n = (max_reward - max(rewards[rewards<(max_reward-1e-8)]))
pair_deltas = np.abs(rewards[:, np.newaxis] - rewards[np.newaxis, :])
Delta = np.min(pair_deltas[pair_deltas>1e-10])
print("Delta_KL:", Delta_KL)
print("Delta_n:", Delta_n)
print("Delta:", Delta)
print("T needed:", 1/Delta**2)
