import pickle

from matplotlib import rc
import numpy as np
from matplotlib import pyplot as plt

rc('font', **{'family': 'serif', 'serif': ['Computer Modern'], 'size': 16})
rc('text', usetex=True)

N = 5
K = 1
F_name = "truncexpon"
algos = [
    "ucb1",
    "exp3",
    "osub",
    "local_greedy",
    "greedy_grid"
]
display_params = {
    "local_greedy": {"label":"Local Greedy", "ls":"-", "color":"tab:green"},
    "exp3": {"label":"Exp3", "ls":":", "color":"tab:purple"},
    "osub": {"label":"OSUB", "ls":"--", "color":"tab:blue"},
    "ucb1": {"label":"UCB1", "ls":(0, (5, 10)), "color":"tab:red"},
    "greedy_grid": {"label":"Greedy Grid", "ls":"-.", "color":"tab:cyan"},
}

def plot_regret(regret_trajectories, ax, algo_name, display_params):
    cum_regret = np.cumsum(regret_trajectories, axis=1)
    quantiles = np.quantile(cum_regret, [0.1, 0.9], axis=0)
    mean = cum_regret.mean(axis=0)
    mean_line, = ax.plot(mean,
                         label=display_params[algo_name]["label"],
                         color=display_params[algo_name]["color"],
                         ls=display_params[algo_name]["ls"],
                         lw=2)
    ax.fill_between(range(regret_trajectories.shape[1]), quantiles[0,:], quantiles[1,:], color=mean_line.get_color(), alpha=0.2, linewidth=0)


f = plt.gcf()
ax = plt.gca()
for algo_name in algos:
    with open("exp_3_results/"+algo_name+"_K="+str(K)+"_N="+str(N)+"_F="+F_name+'.pickle', 'rb') as f:
        data = pickle.load(f)

    plot_regret(data["expected_regret"], ax, algo_name=algo_name, display_params=display_params)

ax.legend()
ax.set_title(r"Expected Regret ${\cal R}(T)$")
ax.set_xlabel(r"Horizon $T$")
plt.savefig("exp_3.png")
plt.show()

