import numpy as np
from gym import utils
from gym.envs.mujoco import mujoco_env


class SwimmerPosEnv(mujoco_env.MujocoEnv, utils.EzPickle):
    noise_scale = 10
    def __init__(self):
        mujoco_env.MujocoEnv.__init__(self, "swimmer.xml", 4)
        utils.EzPickle.__init__(self)

    def step(self, a):
        ctrl_cost_coeff = 0.0001
        xposbefore = self.sim.data.qpos[0]
        self.do_simulation(a, self.frame_skip)
        xposafter = self.sim.data.qpos[0]

        reward_fwd = abs(xposafter - xposbefore) / self.dt
        reward_ctrl = -ctrl_cost_coeff * np.square(a).sum()
        reward = reward_fwd + reward_ctrl
        ob = self._get_obs()

        info = dict(
            reward_fwd=reward_fwd,
            reward_ctrl=reward_ctrl,
            x_position = xposafter,
        )

        if xposafter > 0.5:
            reward += np.random.randn() * self.noise_scale

        return ob, reward, False, info

    def _get_obs(self):
        qpos = self.sim.data.qpos
        qvel = self.sim.data.qvel
        return np.concatenate([qpos.flat[0:2]/100., qpos.flat[2:], qvel.flat])

    def reset_model(self):
        self.set_state(
            self.init_qpos
            + self.np_random.uniform(low=-0.1, high=0.1, size=self.model.nq),
            self.init_qvel
            + self.np_random.uniform(low=-0.1, high=0.1, size=self.model.nv),
        )
        return self._get_obs()
