from gymnasium.envs.registration import register
from gymnasium.envs.registration import WrapperSpec
from gymnasium.wrappers import TransformReward

register(
    id="BipedalWalkerHardcoreModes-v3",
    entry_point="bipedal_walker_hardcore_modes.env:BipedalWalkerModes",

    additional_wrappers=(
        WrapperSpec(
            name=TransformReward.__name__,
            entry_point="gymnasium.wrappers:TransformReward",
            kwargs=dict(
                f=lambda r: max(r, 0.0),
            ),
        ),
    ),

    # Same parameters as `BipedalWalkerHardcore-v3`:
    kwargs={"hardcore": True},
    max_episode_steps=2000,
    reward_threshold=300,
)
