# SWMPO experiments

This repository contains code to run SWMPO on some example environments.

**ICLR reviewer: please clone [rl-trained-agents](https://github.com/DLR-RM/rl-trained-agents) into `lib/rl-trained-agents`.** Due to limitations on the file size upload for supplementary material.

## How to run

Clone and change directory to the repository. Then create and activate a python
virtual environment and execute one of the scripts to verify you can run the
code. I recommend using Poetry for dependency management.

In bash, this would look something like this:

```sh
git clone --recurse-submodules ANONYMISED
cd swmpo-experiments
python -m venv venv
source venv/bin/activate
python -m pip install poetry
poetry install
pip install -e lib/swmpo
pip install -e lib/terrain-mass
pip install -e lib/autonomous-verification
pip install -e lib/salamander-env
pip install -e lib/bipedal-walker-hardcore-modes
python swmpo_experiments/pipeline.py --hyperparameter_json swmpo_experiments/salamander.json
```

The salamander script requires [Webots](https://en.wikipedia.org/wiki/Webots) and
[`xvfb`](https://en.wikipedia.org/wiki/Xvfb). Fffpmeg should be in your path.
