import os
import shutil

# 定义源文件夹和目标文件夹路径
source_folder = "DATA/dresscode/upper_body/images_512"  # 替换为源文件夹的实际路径
destination_folder = "DATA/dresscode/upper_body/images_5123"  # 替换为目标文件夹的实际路径

# 检查并创建目标文件夹
if not os.path.exists(destination_folder):
    os.makedirs(destination_folder)

# 生成源文件列表
start_num = 48392  # 文件名编号的起始值
end_num = 50191    # 文件名编号的结束值

# 遍历文件编号范围
for num in range(start_num, end_num + 1):
    # 格式化为 6 位数字，并添加文件名后缀
    source_filename = f"{num:06d}_0.jpg"
    source_path = os.path.join(source_folder, source_filename)
    destination_path = os.path.join(destination_folder, source_filename)

    # 检查源文件是否存在
    if os.path.exists(source_path):
        # 复制文件到目标文件夹
        shutil.copy2(source_path, destination_path)
        print(f"Successfully copied: {source_filename}")
    else:
        print(f"File {source_filename} not found in source folder, skipping.")