# Code references
Our implementation is based on "BioT5: Enriching Cross-modal Integration in Biology with Chemical Knowledge and Natural Language Associations" (https://github.com/QizhiPei/BioT5). 


### How to train?

The training requires four NVIDIA A100 GPUs. You can start the training by

```bash
python construct_SFT_datasets.py
```

```bash
python filter_dataset.py
```

```bash
accelerate launch sft_learning.py 
```

To run reinforcement learning, you should use the uploaded TRL package with transformers==4.33.3


```bash
accelerate launch reinforce.py --init_kl_coef 0.01 --learning_rate 5e-5 --batch_size 32 --wandb_name RL_lora --base_model_name SFT_model
```

### How to generate?

You can run generation by
```bash
python generate_our.py --gpu_id 0 --model_name RL_model
```