import numpy as np

def p_rule(y_pred, z_values):
    '''
    p% rule to assess demographic parity.
    y_pred is the zero-one prediction vector, isn'it??
    '''
    y_z_1 = y_pred[z_values == 1]
    y_z_0 = y_pred[z_values == 0]
    odds = np.mean(y_z_1) / np.mean(y_z_0)
    return np.min([odds, 1/odds]) * 100

def p_rule_diff(y_pred, z_values):
    '''
    p% rule to assess demographic parity.
    '''
    y_z_1 = y_pred[z_values == 1]
    y_z_0 = y_pred[z_values == 0]
    odds = np.abs(np.mean(y_z_1) - np.mean(y_z_0))
    return odds*100

def disparate_mistreatment(y_pred, y_true, z_values):
    '''
    Disparate Mistreatments for equalized odds.
    '''
    y_z_1 = y_pred[(z_values == 1) & (y_true == 1)]
    y_z_0 = y_pred[z_values == 0]
    
    TPR_Z1 = np.mean(y_pred[(z_values == 1) & (y_true == 1)])
    TPR_Z0 = np.mean(y_pred[(z_values == 0) & (y_true == 1)])
    
    FPR_Z1 = np.mean(y_pred[(z_values == 1) & (y_true == 0)])
    FPR_Z0 = np.mean(y_pred[(z_values == 0) & (y_true == 0)])
    
    return np.abs(TPR_Z1-TPR_Z0)+np.abs(FPR_Z1-FPR_Z0)
    


    
