names_resnet_cifar = [
    'resnet-adabelief-lr0.001-betas0.9-0.999-eps1e-08-wdecay0.0005-run0-resetFalse',
    'resnet-sgd-lr0.1-momentum0.9-wdecay0.0005-run0-resetFalse',
    'resnet-adabound-lr0.001-betas0.9-0.999-final_lr0.1-gamma0.001-wdecay0.0005-run0-resetFalse',
    'resnet-yogi-lr0.001-betas0.9-0.999-eps0.001-wdecay0.0005-run0-resetFalse',
    'resnet-adam-lr0.001-betas0.9-0.999-wdecay0.0005-eps1e-08-run0-resetFalse',
    'resnet-msvag-lr0.1-betas0.9-0.999-eps1e-08-wdecay0.0005-run0-resetFalse',
    'resnet-radam-lr0.001-betas0.9-0.999-wdecay0.0005-eps1e-08-run0-resetFalse',
    'resnet-adamw-lr0.001-betas0.9-0.999-wdecay0.01-eps1e-08-run0-resetFalse',
    'resnet-fromage-lr0.01-betas0.9-0.999-wdecay0.0005-eps1e-08-run0-resetFalse',
    'resnet-apollo-lr1.0-beta10.9-eps0.0001-wdecay0.00025-run0-rebound-constant-warmup-200-init_lr-0.01-wd_type-L2-resetFalse'
]


optimizer_std_dev_resnet_cifar10 = {
     'AdaBelief' : [(0, 149, 0.5), (150, 199, 0.125)],
     'SGD' : [(0, 140, 0), (141, 199, 0.4 )],
     'AdaBound': [(0, 149, 0.6), (150, 199, 0.1)],
     'Yogi': [(0, 149, 0.4), (150, 199, 0.1)],
     'Adam': [(0, 120, 0.6), (121, 149, 0.7), (150, 199, 0.35)],
     'MSVAG' : [(0, 149, 0.3), (150, 199, 0.1) ],
     'RAdam': [(0, 25, 0.6), (26, 87, 0.15), (88, 129, 0.3), (130, 199, 0.15)],
     'AdamW': [(0, 79, 0.3), (80, 149, 0.4), (150, 199, 0.2)],
     'Fromage': [(0, 149, 0.7), (150, 199, 0.5)],
     'Apollo': [(0, 149, 0.5), (150, 199, 0.2)]
}

optimizer_std_dev_resnet_cifar100 = {
     'AdaBelief' : [(0, 50, 0.8), (51, 149, 0.7), (150, 199, 0.2)],
     'SGD' : [(0, 140, 0), (141, 187, 0.2), (188, 199, 0.4)],
     'AdaBound': [(0, 124, 0.2), (125, 149, 0.4), (150, 199, 0.6, 1)],
     'Yogi': [(0, 149, 0.5), (150, 199, 0.1)],
     'Adam': [(0, 149, 1), (150, 199, 0.2)],
     'MSVAG' : [(0, 149, 0.4), (150, 199, 0.15)],
     'RAdam': [(0, 74, 0.2), (75, 149, 0.4), (150, 174, 0.6, 1), (175, 199, 0.45)],
     'AdamW': [(0, 149, 0.4), (150, 199, 0.2)],
     'Fromage': [(0, 149, 0.7), (150, 199, 0.4)],
     'Apollo': [(0, 149, 0.35), (150, 199, 0.09)]
}

names_vgg_cifar = [
    'vgg-adabelief-lr0.001-betas0.9-0.999-eps1e-08-wdecay0.0005-run0-resetFalse',
    'vgg-sgd-lr0.1-momentum0.9-wdecay0.0005-run0-resetFalse',
    'vgg-adabound-lr0.001-betas0.9-0.999-final_lr0.1-gamma0.001-wdecay0.0005-run0-resetFalse',
    'vgg-yogi-lr0.001-betas0.9-0.999-eps0.001-wdecay0.0005-run0-resetFalse',
    'vgg-adam-lr0.001-betas0.9-0.999-wdecay0.0005-eps1e-08-run0-resetFalse',
    'vgg-msvag-lr0.1-betas0.9-0.999-eps1e-08-wdecay0.0005-run0-resetFalse',
    'vgg-radam-lr0.001-betas0.9-0.999-wdecay0.0005-eps1e-08-run0-resetFalse',
    'vgg-adamw-lr0.001-betas0.9-0.999-wdecay0.01-eps1e-08-run0-resetFalse',
    'vgg-fromage-lr0.01-betas0.9-0.999-wdecay0.0005-eps1e-08-run0-resetFalse',
    'vgg-apollo-lr1.0-beta10.9-eps0.0001-wdecay0.00025-run0-rebound-constant-warmup-200-init_lr-0.01-wd_type-L2-resetFalse'
]


optimizer_std_dev_vgg_cifar10 = {
    'AdaBelief' : [(0, 25, 0.9), (26, 110, 0.35), (111, 149, 0.15), (150, 199, 0.2)],
    'SGD' : [(0, 149, 0.1), (150, 160, 0.2), (161, 180, 0.3), (181, 199, 0.45)],
    'AdaBound': [(0, 30, 0.62), (31, 150, 0.35), (151, 199, 0.25)],
    'Yogi': [(0, 25, 0.6), (26, 149, 0.4), (150, 199, 0.2)],
    'Adam': [(0, 99, 0.4), (100, 150, 0.5), (151, 199, 0.2)],
    'MSVAG' : [(0, 25, 0.45), (26, 150, 0.3), (151, 199, 0.35) ],
    'RAdam': [(0, 150, 0.4), (151, 155, 1.3, 1), (156, 161, 1.0,1), (162, 199, 0.7,1)],
    'AdamW': [(0, 75, 0.6), (76, 150, 0.4), (151, 199, 0.4)],
    'Fromage': [(0, 150, 0.3), (151, 199, 0.2)],
    'Apollo': [(0, 149, 0.5), (150, 199, 0.2)]
}

optimizer_std_dev_vgg_cifar100 = {
    'AdaBelief' : [(0, 75, 0.6), (76, 150, 0.7), (151, 199, 0.3)],
    'SGD' : [(0, 149, 0), (150, 199, 0.4)],
    'AdaBound': [(0, 149, 0.3),  (150, 199, 0.2)],
    'Yogi': [(0, 50, 0.4), (51, 149, 0.7), (150, 199, 0.2)],
    'Adam': [(0, 40, 0), (41, 149, 0.8), (150, 199, 0.35)],
    'MSVAG' : [(0, 149, 0.55), (150, 199, 0.2)],
    'RAdam': [(0, 149, 0.55), (150, 199, 0.65)],
    'AdamW': [(0, 149, 0.55), (150, 199, 0.3)],
    'Fromage': [(0, 149, 0.7), (150, 199, 0.3)],
    'Apollo': [(0, 149, 0.35), (150, 199, 0.09)]
}

names_densenet_cifar = [
    'densenet-adabelief-lr0.001-betas0.9-0.999-eps1e-08-wdecay0.0005-run0-resetFalse',
    'densenet-sgd-lr0.1-momentum0.9-wdecay0.0005-run0-resetFalse',
    'densenet-adabound-lr0.001-betas0.9-0.999-final_lr0.1-gamma0.001-wdecay0.0005-run0-resetFalse',
    'densenet-yogi-lr0.001-betas0.9-0.999-eps0.001-wdecay0.0005-run0-resetFalse',
    'densenet-adam-lr0.001-betas0.9-0.999-wdecay0.0005-eps1e-08-run0-resetFalse',
    'densenet-msvag-lr0.1-betas0.9-0.999-eps1e-08-wdecay0.0005-run0-resetFalse',
    'densenet-radam-lr0.001-betas0.9-0.999-wdecay0.0005-eps1e-08-run0-resetFalse',
    'densenet-adamw-lr0.001-betas0.9-0.999-wdecay0.01-eps1e-08-run0-resetFalse',
    'densenet-fromage-lr0.01-betas0.9-0.999-wdecay0.0005-eps1e-08-run0-resetFalse',
    'densenet-apollo-lr1.0-beta10.9-eps0.0001-wdecay0.00025-run0-rebound-constant-warmup-200-init_lr-0.01-wd_type-L2-resetFalse'
]

optimizer_std_dev_densenet_cifar10 = {
    'AdaBelief' : [(0, 37, 0.3), (38, 149, 0.4), (150, 199, 0.1)],
    'SGD' : [(0, 140, 0), (141, 199, 0.3)],
    'AdaBound': [(0, 59, 0.3), (60, 149, 0.45), (150, 199, 0.25)],
    'Yogi': [(0, 30, 0.2), (31, 149, 0.35), (150, 199, 0.2)],
    'Adam': [(0, 149, 0.7), (150, 199, 0.25)],
    'MSVAG' : [(0, 149, 0.4), (150, 199, 0.1)],
    'RAdam': [(0, 149, 0.3), (150, 199, 0.2)],
    'AdamW': [(0, 59, 0.1), (60, 149, 0.2), (150, 199, 0.1)],
    'Fromage': [(0, 149, 0.6), (150,199, 0.2)],
    'Apollo': [(0, 149, 0.5), (150, 199, 0.2)]
}

optimizer_std_dev_densenet_cifar100 = {
    'AdaBelief' : [(0, 149, 0.3), (150, 199, 0.3)],
    'SGD' : [(0, 140, 0), (141, 199, 0.5)],
    'AdaBound': [(0, 149, 0.9), (150, 199, 0.2)],
    'Yogi': [(0, 29, 0.1), (30, 149, 0.5), (150, 199, 0.1)],
    'Adam': [(0, 149, 0.4), (150, 199, 0.2)],
    'MSVAG' : [(0, 149, 0.2), (150, 199, 0.3)],
    'RAdam': [(0, 149, 0.45), (150, 199, 0.2)],
    'AdamW': [(0, 149, 0.35), (150, 199, 0.1)],
    'Fromage': [(0, 149, 0.7), (150, 199, 0.3)],
    'Apollo': [(0, 149, 0.35), (150, 199, 0.09)]
}

names_lstm_one_layer = [
    'PTB.pt-niter-200-optimizer-adabelief-nlayers1-lr0.001-clip-0.25-eps1e-16-epsqrt0.0-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-sgd-nlayers1-lr30.0-clip-0.25-eps1e-12-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-adabound-nlayers1-lr0.01-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-yogi-nlayers1-lr0.01-clip-0.25-eps0.001-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-adam-nlayers1-lr0.001-clip-0.25-eps1e-12-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-msvag-nlayers1-lr30.0-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-radam-nlayers1-lr0.001-clip-0.25-eps1e-12-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-adamw-nlayers1-lr0.001-clip-0.25-eps1e-12-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-fromage-nlayers1-lr0.01-clip-0.25-eps1e-12-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]'

]

optimizer_std_dev_lstm_one_layer = {
    'AdaBelief' : [(0, 50, 0.2), (51, 199, 0.3)],
    'SGD' : [(0, 99, 1), (100, 199, 0.2)],
    'AdaBound': [(0, 99, 0.5), (100, 199, 0.15)],
    'Yogi': [(0, 99, 0.2), (100, 199, 0.2)],
    'Adam': [(0, 99, 0.1), (100, 199, 0.25)],
    'MSVAG' : [(0, 99, 0.3), (100, 199, 0.1)],
    'RAdam': [(0, 199, 0.1)],
    'AdamW': [(0, 99, 0.15), (100, 199, 0.1)],
    'Fromage': [(0, 26, 0.1), (27, 99, 1), (100, 199, 0.1)],
}


names_lstm_two_layer = [
    'PTB.pt-niter-200-optimizer-adabelief-nlayers2-lr0.01-clip-0.25-eps1e-12-epsqrt0.0-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-sgd-nlayers2-lr30.0-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-adabound-nlayers2-lr0.01-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-yogi-nlayers2-lr0.01-clip-0.25-eps0.001-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-adam-nlayers2-lr0.01-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-msvag-nlayers2-lr30.0-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-radam-nlayers2-lr0.001-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-adamw-nlayers2-lr0.001-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-fromage-nlayers2-lr0.01-clip-0.25-eps1e-12-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]'

]

optimizer_std_dev_lstm_two_layer = {
    'AdaBelief' : [(0, 24, 0.75), (25, 54, 1), (55, 99, 1.5), (100, 199, 0.2)],
    'SGD' : [(0, 24, 0.8), (25, 50, 3), (51, 99, 2), (100, 199, 0.1)],
    'AdaBound': [(0, 24, 0.2), (25, 99, 0.8), (100, 199, 0.5)],
    'Yogi': [(0, 199, 0.1)],
    'Adam': [(0, 74, 0.7), (75, 110, 0.4), (111, 199, 0.1)],
    'MSVAG' : [(0, 25, 0.1), (26, 99, 0.6), (100, 199, 0.4)],
    'RAdam': [(0, 99, 0.2), (100, 199, 0.1)],
    'AdamW': [(0, 36, 0.3), (37, 99, 0.6), (100, 199, 0.5)],
    'Fromage': [(0, 25, 0.2), (26, 99, 2.0), (100, 199, 0.3)],
}

names_lstm_three_layer = [
    'PTB.pt-niter-200-optimizer-adabelief-nlayers3-lr0.01-clip-0.25-eps1e-12-epsqrt0.0-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-sgd-nlayers3-lr30.0-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-adabound-nlayers3-lr0.01-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-yogi-nlayers3-lr0.01-clip-0.25-eps0.001-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-adam-nlayers3-lr0.01-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-msvag-nlayers3-lr30.0-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-radam-nlayers3-lr0.001-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-adamw-nlayers3-lr0.001-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'PTB.pt-niter-200-optimizer-fromage-nlayers3-lr0.01-clip-0.25-eps1e-12-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]'




]

optimizer_std_dev_lstm_three_layer = {
    'AdaBelief' : [(0, 25, 0.7), (26, 99, 1.2),  (100, 199, 0.3)],
    'SGD' : [(0, 25, 0.6), (26, 99, 1.4), (100, 199, 0.1)],
    'AdaBound': [(0, 25, 0.5), (26, 99, 0.8), (100, 199, 0.4)],
    'Yogi': [(0, 199, 0.1)],
    'Adam': [(0, 99, 1), (100, 124, 0.7), (125, 199, 0.4)],
    'MSVAG' : [(0, 49, 0.3), (50, 99, 0.5), (100, 199, 0.4)],
    'RAdam': [(0, 37, 0.2), (38, 99, 0.5), (100, 199, 0.2)],
    'AdamW': [(0, 25, 0.1), (26, 99, 0.6), (100, 199, 0.7)],
    'Fromage': [(0, 37, 0.3), (38, 99, 1.6), (100, 199, 0.6)],
}

labels = [
    'AdaBelief',
    'SGD',
    'AdaBound',
    'Yogi',
    'Adam',
    'MSVAG',
    'RAdam',
    'AdamW',
    'Fromage',
    'Apollo'
]

CIFAR10_curve_root = '/path/to/classification_cifar10/curve'
CIFAR100_curve_root = '/path/to/classification_cifar100/curve'
LSTM_curve_root = '/path/to/LSTM/curve'


CIFAR100_densenet_config = {
    'test': {
        'curve_paths': names_densenet_cifar,
        'std_dev': optimizer_std_dev_densenet_cifar100,
        'ylim': (64, 80),
        'ygap': 2,
        'acc_ppl': 'acc'
    },
    'train': {
        'curve_paths': names_densenet_cifar,
        'std_dev': optimizer_std_dev_densenet_cifar100,
        'ylim': (80, 100),
        'ygap': 2.5,
        'acc_ppl': 'acc'
    }

}


CIFAR10_densenet_config = {
    'test': {
        'curve_paths': names_densenet_cifar,
        'std_dev': optimizer_std_dev_densenet_cifar10,
        'ylim': (88, 96),
        'ygap': 1,
        'acc_ppl': 'acc'
    },
    'train': {
        'curve_paths': names_densenet_cifar,
        'std_dev': optimizer_std_dev_densenet_cifar10,
        'ylim': (80, 100),
        'ygap': 2.5,
        'acc_ppl': 'acc'
    }
}

CIFAR100_vgg_config = {
    'test': {
        'curve_paths': names_vgg_cifar,
        'std_dev': optimizer_std_dev_vgg_cifar100,
        'ylim': (45, 70),
        'ygap': 5,
        'acc_ppl': 'acc'
    },
    'train': {
        'curve_paths': names_vgg_cifar,
        'std_dev': optimizer_std_dev_vgg_cifar100,
        'ylim': (50, 100),
        'ygap': 5,
        'acc_ppl': 'acc'
    }

}

CIFAR100_vgg_config_train = {

}

CIFAR10_vgg_config = {
    'test': {
        'curve_paths': names_vgg_cifar,
        'std_dev': optimizer_std_dev_vgg_cifar10,
        'ylim': (84, 92),
        'ygap': 1,
        'acc_ppl': 'acc'
    },
    'train': {
        'curve_paths': names_vgg_cifar,
        'std_dev': optimizer_std_dev_vgg_cifar10,
        'ylim': (80, 100),
        'ygap': 2.5,
        'acc_ppl': 'acc'
    }

}



CIFAR10_resnet_config = {
    'test': {
        'curve_paths': names_resnet_cifar,
        'std_dev': optimizer_std_dev_resnet_cifar10,
        'ylim': (88, 96),
        'ygap': 1,
        'acc_ppl': 'acc'
    },
    'train': {
        'curve_paths': names_resnet_cifar,
        'std_dev': optimizer_std_dev_resnet_cifar10,
        'ylim': (80, 100),
        'ygap': 2.5,
        'acc_ppl': 'acc'
    }
}

CIFAR100_resnet_config = {
    'test': {
        'curve_paths': names_resnet_cifar,
        'std_dev': optimizer_std_dev_resnet_cifar100,
        'ylim': (64, 78),
        'ygap': 2,
        'acc_ppl': 'acc'
    },
    'train': {
        'curve_paths': names_resnet_cifar,
        'std_dev': optimizer_std_dev_resnet_cifar100,
        'ylim': (80, 100),
        'ygap': 2.5,
        'acc_ppl': 'acc'
    }

}

LSTM_one_layer_config = {
    'test': {
        'curve_paths': names_lstm_one_layer,
        'std_dev': optimizer_std_dev_lstm_one_layer,
        'ylim': (84, 105),
        'ygap': 2,
        'acc_ppl': 'loss'
    },
    'train':{
        'curve_paths': names_lstm_one_layer,
        'std_dev': optimizer_std_dev_lstm_one_layer,
        'ylim': (50, 120),
        'ygap': 10,
        'acc_ppl': 'loss'
    }

}

LSTM_two_layer_config = {
    'test': {
        'curve_paths': names_lstm_two_layer,
        'std_dev': optimizer_std_dev_lstm_two_layer,
        'ylim': (65, 100),
        'ygap': 5,
        'acc_ppl': 'loss'
    },
    'train': {
        'curve_paths': names_lstm_two_layer,
        'std_dev': optimizer_std_dev_lstm_two_layer,
        'ylim': (40, 120),
        'ygap': 10,
        'acc_ppl': 'loss'
    }
}


LSTM_three_layer_config = {
    'test': {
        'curve_paths': names_lstm_three_layer,
        'std_dev': optimizer_std_dev_lstm_three_layer,
        'ylim': (60, 100),
        'ygap': 5,
        'acc_ppl': 'loss'
    },
    'train': {
        'curve_paths': names_lstm_three_layer,
        'std_dev': optimizer_std_dev_lstm_three_layer,
        'ylim': (30, 110),
        'ygap': 10,
        'acc_ppl': 'loss'
    }
}


names_WT2_one_layer = [
    'WT2.pt-niter-750-optimizer-adabelief-nlayers1-lr0.001-clip-0.25-eps1e-16-epsqrt0.0-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'WT2.pt-niter-750-optimizer-adam-nlayers1-lr0.001-clip-0.25-eps1e-12-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]'
]

names_WT2_two_layer = [
    'WT2.pt-niter-750-optimizer-adabelief-nlayers2-lr0.01-clip-0.25-eps1e-12-epsqrt0.0-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'WT2.pt-niter-750-optimizer-adam-nlayers2-lr0.01-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]'
]

names_WT2_three_layer = [
    'WT2.pt-niter-750-optimizer-adabelief-nlayers3-lr0.01-clip-0.25-eps1e-12-epsqrt0.0-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]',
    'WT2.pt-niter-750-optimizer-adam-nlayers3-lr0.01-clip-0.25-eps1e-08-epsqrt1e-08-betas-0.9-0.999-run0-wdecay1.2e-06-when-[100, 145]'
]

### 1 layer lstm WT2
# test
optimizer_std_dev_lstm_1_layer_wt2_test = {
    'AdaBelief' : [(0, 25, 0.4), (26, 50, 0.5), (51, 75, 0.9), (76, 100, 1.0), (101, 199, 0.7)],
    'Adam': [(0, 25, 0.4), (26, 50, 0.6), (51, 75, 0.9), (76, 100, 1.1), (101, 199, 0.8)],
}

# train
optimizer_std_dev_lstm_1_layer_wt2_train = {
    'AdaBelief' : [(0, 25, 1.2), (26, 50, 1.3), (51, 75, 1.5), (76, 199, 1.6)],
    'Adam': [(0, 25, 1.2), (26, 50, 1.3), (51, 75, 1.4), (76, 199, 1.5)],
}

### 2 layer lstm WT2
# test
optimizer_std_dev_lstm_2_layer_wt2_test = {
    'AdaBelief' : [(0, 25, 0.5), (26, 50, 1.2), (51, 75, 1.3), (76, 100, 1.4), (101, 199, 0.4)],
    'Adam': [(0, 25, 0.5), (26, 50, 1.3), (51, 75, 1.4), (76, 100, 1.5), (101, 199, 0.4)],
}

# train
optimizer_std_dev_lstm_2_layer_wt2_train = {
     'AdaBelief' : [(0, 25, 0.5), (26, 50, 1.2), (51, 75, 1.3), (76, 100, 1.4), (101, 199, 0.4)],
     'Adam': [(0, 25, 0.5), (26, 50, 1.3), (51, 75, 1.4), (76, 100, 1.5), (101, 199, 0.4)],
}

### 3 layer lstm WT2
# test
optimizer_std_dev_lstm_3_layer_wt2_test = {
    'AdaBelief' : [(0, 20, 0.7), (21, 25, 0.9), (26, 50, 1.4), (51, 100, 1.5), (101, 199, 0.4)],
    'Adam': [(0, 20, 0.7), (21, 25, 0.9), (26, 50, 1.5), (51, 100, 1.6), (101, 199, 0.6)],
}

# train
optimizer_std_dev_lstm_3_layer_wt2_train = {
    'AdaBelief' : [(0, 25, 0.5), (26, 50, 1.3), (51, 100, 1.5), (101, 125, 0.7), (126, 150, 0.9), (151, 199, 1.0)],
    'Adam': [(0, 25, 0.5), (26, 50, 1.3), (51, 100, 1.6), (101, 125, 0.7), (126, 150, 0.9), (151, 199, 1.0)],
}



WT2_labels = [
    'AdaBelief',
    'Adam'
]


WT2_one_layer_config = {
    'test': {
        'curve_paths': names_WT2_one_layer,
        'std_dev': optimizer_std_dev_lstm_1_layer_wt2_test,
        'ylim': (90, 170),
        'ygap': 10,
        'acc_ppl': 'loss'
    },
    'train':{
        'curve_paths': names_WT2_one_layer,
        'std_dev': optimizer_std_dev_lstm_1_layer_wt2_train,
        'ylim': (80, 160),
        'ygap': 10,
        'acc_ppl': 'loss'
    }
}

WT2_two_layer_config = {
    'test': {
        'curve_paths': names_WT2_two_layer,
        'std_dev': optimizer_std_dev_lstm_2_layer_wt2_test,
        'ylim': (60, 140),
        'ygap': 10,
        'acc_ppl': 'loss'
    },
    'train': {
        'curve_paths': names_WT2_two_layer,
        'std_dev': optimizer_std_dev_lstm_2_layer_wt2_train,
        'ylim': (50, 130),
        'ygap': 10,
        'acc_ppl': 'loss'
    }
}


WT2_three_layer_config = {
    'test': {
        'curve_paths': names_WT2_three_layer,
        'std_dev': optimizer_std_dev_lstm_3_layer_wt2_test,
        'ylim': (60, 140),
        'ygap': 10,
        'acc_ppl': 'loss'
    },
    'train': {
        'curve_paths': names_WT2_three_layer,
        'std_dev':  optimizer_std_dev_lstm_3_layer_wt2_train,
        'ylim': (40, 120),
        'ygap': 10,
        'acc_ppl': 'loss'
    }
}

