# NOTE
- This code is provided as supplementary material for the following ICLR 2022 submission:
    - Paper ID: 1785
    - Paper Title: Scalable Sampling for Nonsymmetric Determinantal Point Processes
- The codes will be open-sourced in the future; please do not distribute.

# Organization
- The code files are organized for (1) sampling nonymmetric DPPs (NDPPs) and (2) NDPP learning with orthogonality constraints.
- The code is based on https://github.com/cgartrel/nonsymmetric-DPP-learning/ (Scalable Learning and MAP Inference for Nonsymmetric Determinantal Point Processes, ICLR 2021).

# Usage

## Experiments for learning orthonal NDPPs:

- First, download the datasets 
    ```
    cd ./learning
    bash download.sh
    ```

- To run ONDPP learning with the UK Retail dataset:
    ```
    cd ./learning
    bash script_ondpp.sh
    ```

## Experiments for scalable sampling from NDPPs:

- To run synthetic dataset experiments: 
    ```
    cd ./sampling
    python run_synthetic.py
    ```

- This will run the Cholesky-based sampling and tree-based rejection sampling.
- Parameters in ``run_synthetic.py'' (e.g., ground set size) can be changed.
- Models learned from real-world datasets also can be used for sampling (parameters are saved in ../learning/saved_models/).
