# Improving Feature Alignment in ConvNets using ContrastiveCAMs and Core-Focused Cross-Entropy

Install required python libraries and download datasets:
```bash
pip install -r requirements.txt
git init
dvc pull -r origin
```
Please also download and store ImageNet-1K in `data/imagenet/images`.

From here, you can re-run training using `train.sh` in the project root:
```bash
./train.sh $MODEL_NAME
```
Where `$MODEL_NAME` includes the following substrings (in any order):
1. `default` / `contrastive` - whether to use CE or CFCE respectively.
   a. If `contrastive`, `kld` / `ablated_only` - whether or not to use KL regularization.
2. `sbd` / `hardimagenet` / `oxford` - which dataset to train on.
3. `pretrained` - whether (random initialization by default) to initialize with ImageNet weights.
4. `adam` - whether (SGD by default) to use Adam optimizer

I like to use `_` separation, using which an example command would be: `./train.sh hardimagenet_contrastive_kld_pretrained_adam`.

To run any of the eval modules, use the following template:
```
python -m src.evals.path.to.file $MODEL_NAME/$CHECKPOINT_TYPE
```
When running from project root, with `$CHECKPOINT_TYPE` being either 'best' (w.r.t. validation metric) or 'last' (final weight update).
