import random
import matplotlib.pyplot as plt
import numpy as np
import math
from sklearn import linear_model
from sklearn.ensemble import RandomForestRegressor
from statsmodels.nonparametric.kernel_regression import KernelReg
from numpy import linalg as la

i_number =1

while True:

    n = 300
    n_dep = 100
    p = 100
    N = 24000
    t = 0.0001  # lambda

    # x随机取值

    mean = np.zeros(shape=[p])

    cov = np.load(r'E:/Code/cov_cs.npy')

    size = (n, 1)
    x_solo = np.random.multivariate_normal(mean, cov, size)
    x = np.zeros(shape=[n, p])
    for i in range(n):
        x[i] = x_solo[i]

    # e随机取值
    e = []
    for _ in range(n):
        e.append(random.normalvariate(0, 0.1))
    e = np.array(e)

    # 测试集e
    e_test = []
    for _ in range(n):
        e_test.append(random.normalvariate(0, 0.1))
    e_test = np.array(e_test)


    b = []
    for _ in range(n * N):
        b.append(random.normalvariate(0, 1))
    b = np.array(b)
    b = b.reshape(n, N)

    b_test = []
    for _ in range(n * N):
        b_test.append(random.normalvariate(0, 1))
    b_test = np.array(b_test)
    b_test = b_test.reshape(n, N)

    #  通过模型计算出y的取值
    y = np.zeros(shape=[n])
    for i in range(n):
        y[i] = np.square(x[i][0] + x[i][1] + x[i][2]) + 1 + e[i]

    # w的取值（均匀分布）
    w = np.zeros(shape=[N, p])
    for i in range(N):
        w[i] = np.random.uniform(-1, 1, size=p)

    # 标准化wi 范数为1
    w_norm = np.zeros(shape=[N, p])
    for i in range(N):
        for j in range(p):
            w_norm[i][j] = w[i][j] / np.sqrt(np.sum(np.square(w[i])))

    # 测试集x3
    # 测试集y
    x_test = np.load(r'E:/Code/x_test_corr_cs.npy')

    y_test = np.zeros(shape=[n])
    for i in range(n):
        y_test[i] = np.square(x_test[i][0] + x_test[i][1] + x_test[i][2]) + 1 + e_test[i]

    #
    k = np.dot(x, w_norm.T) + b
    k_test = np.dot(x_test, w_norm.T)+ b_test


    k2 = np.zeros(shape=[n, N])
    k2_test = np.zeros(shape=[n, N])
    for i in range(N):
        kde = KernelReg(endog=y.reshape(-1,1), exog=k[:, i].reshape(-1,1), var_type='c', bw=[0.75])
        k2[:, i] = kde.fit(k[:, i].reshape(-1,1))[0]
        k2_test[:, i] = kde.fit(k_test[:, i].reshape(-1,1))[0]

    # 估计alpha
    f1 = np.linalg.inv(np.dot(k2.T, k2) + N * t / p * np.identity(N))
    f2 = np.dot(f1, k2.T)
    alpha = np.dot(f2, y)


    # 估计 y hat
    y_hat = np.dot(k2_test, alpha) + e_test

    # MSE
    MSE = np.sqrt(np.sum(np.square((y_test - y_hat) / ((y_test) / 2))) / 300)
    print(MSE)


    i_number += 1
    if i_number > 100:
        break