# FHGS: Feature-Homogenized Gaussian Splatting

## 3D Scene Understanding with Multi-View Consistency


![](images/global.png)

FHGS ensures feature consistency across different views while maintaining high-quality 3D scene representation and understanding.


## Installation

```bash
cd FHGS

# Initialize and update submodules
git submodule init
git submodule update --remote

# Create conda environment
conda env create --file environment.yml

# Install non-differentiable feature fusion mechanism
conda activate FHGS
pip install submodules/feature_fusion
pip install submodules/simple-knn
pip install submodules/non_diff_mechanism
```

### Download SAM Model Weights

Download the SAM model weights from our [Google Drive](https://drive.google.com/drive/folders/1DPllz8nAvPCJsfwyvaHMwO2VTlmyXIfP?usp=sharing).
into /model


Download the DTU from our [DTU Google Drive](https://drive.google.com/file/d/1afH-ufDUcKEos2wYFFj2tL6FtfRdW-Rk/view?usp=sharing)
## Usage

### 1. Structure from Motion (SFM)

```bash
# Install colmap
sudo apt install colmap

# Run SFM
python run_colmap_sfm.py --data_folder <path to data> --max_resolution 1200 --skip 0 --dense_factor 2.5
```

Parameter description:
- `skip`: Number of images to skip
- `max_resolution`: Image downsampling resolution
- `dense_factor`: Densification factor for the initial point cloud

### 2. SAM-General Feature Fusion Architecture

```bash
python run_sam_gs.py --data_folder <path to data>/undistorted/
```

### 3. FHGS Training

```bash
cd <path to code>/2d-gaussian-splatting/
python train.py -s <path to data>/undistorted/ -m <path to outputdata>/
```

Sigmoid parameter settings:
- In `<path to code>/2d-gaussian-splatting/submodules/non_diff_mechanism/cuda_rasterizer/auxiliary.h`:
  - `cos_sim_lambda = 0.6`
  - `cos_sim_k = 25.0f`

### 4. Testing and Rendering

```bash
python render.py -r 2 --depth_ratio 1 -m <path to outputdata> --iteration 20000
```



