import os
import cv2

def merge_channels_to_rgb(folder_r, folder_g, folder_b, output_folder):
    # 创建输出文件夹
    os.makedirs(output_folder, exist_ok=True)

    # 获取文件列表（假设文件名在不同文件夹中一一对应）
    files_r = sorted(os.listdir(folder_r))
    files_g = sorted(os.listdir(folder_g))
    files_b = sorted(os.listdir(folder_b))

    # 检查文件数量是否一致
    if not (len(files_r) == len(files_g) == len(files_b)):
        print("Error: The number of files in the folders do not match.")
        return

    # 遍历文件并融合
    for file_r, file_g, file_b in zip(files_r, files_g, files_b):
        # 构建完整路径
        path_r = os.path.join(folder_r, file_r)
        path_g = os.path.join(folder_g, file_g)
        path_b = os.path.join(folder_b, file_b)

        # 读取图片（假设图片是单通道）
        img_r = cv2.imread(path_r, cv2.IMREAD_GRAYSCALE)
        img_g = cv2.imread(path_g, cv2.IMREAD_GRAYSCALE)
        img_b = cv2.imread(path_b, cv2.IMREAD_GRAYSCALE)

        # 检查图片是否成功读取
        if img_r is None or img_g is None or img_b is None:
            print(f"Error reading one of the files: {file_r}, {file_g}, {file_b}")
            continue

        # 合并成RGB图片
        img_rgb = cv2.merge((img_b, img_g, img_r))

        # 保存到输出文件夹
        output_path = os.path.join(output_folder, file_r)  # 使用R通道的文件名
        cv2.imwrite(output_path, img_rgb)

    print(f"All images have been merged and saved to {output_folder}.")


# folder_r = data_folder + "attention/a19/"  # 存储R通道图片的文件夹
# folder_g = data_folder + "attention/a28/"  # 存储G通道图片的文件夹
# folder_b = data_folder + "attention/a31/"  # 存储B通道图片的文件夹
# output_folder = data_folder + "attention/merge/"  # 输出文件夹
# merge_channels_to_rgb(folder_r, folder_g, folder_b, output_folder)

