# train impute models: grud to predict speed, torque
python neuralfaults/train.py --gpu=0 --num_gpus=1 \
    --loss=mse --metrics=r2,smape,mae --dataset=SpeedTorque \
    --impute_model=grud --inp_quants=i_d,i_q,u_d,u_q \
    --out_quants=speed,torque --fail_quants=i_d,i_q,u_d,u_q \
    --fail_quants_prob=0.1,0.1,0.1,0.1 \
    --lr=0.1 --batch_size=4096 --data_dir=../ --epochs=100

# train impute models: grud to predict filled i_d, i_q, u_d, u_q (grud, mrnn, brits also)
python neuralfaults/train.py --gpu=0 --num_gpus=1 \
    --loss=mse --metrics=r2,smape,mae --dataset=SpeedTorque \
    --impute_model=grud --inp_quants=i_d,i_q,u_d,u_q \
    --out_quants=i_d,i_q,u_d,u_q --fail_quants=i_d,i_q,u_d,u_q \
    --fail_quants_prob=0.1,0.1,0.1,0.1 \
    --lr=0.1 --batch_size=4096 --data_dir=../


# replace impute_model with mean, mice, mf, knn, zero
python neuralfaults/inference.py --gpu=0 --num_gpus=1 \
    --loss=mse --metrics=r2,smape,mae --dataset=SpeedTorque \
    --inp_quants=i_d,i_q,u_d,u_q --out_quants=speed,torque \
    --weight_path=../weights/SpeedTorque/shallow_encdec/0649037148f64b469332c288c9fc0a84.pt \
    --impute_model=mf --fail_quants=i_d,i_q,u_d,u_q \
    --fail_quants_prob=0.1,0.1,0.1,0.1 \
    --batch_size=15000



# replace impute_model with gain, gan, mrnn, brits, e2e, sgan
python neuralfaults/inference.py --gpu=0 --num_gpus=1     \
--loss=mse --metrics=r2,smape,mae --dataset=SpeedTorque    \
 --inp_quants=i_d,i_q,u_d,u_q --out_quants=speed,torque   \
   --weight_path=../weights/SpeedTorque/shallow_encdec/0649037148f64b469332c288c9fc0a84.pt    \
    --impute_model=sgan --fail_quants=i_d,i_q,u_d,u_q     --fail_quants_prob=0.1,0.1,0.1,0.1  \
       --batch_size=4096 --impute_weight_path=../weights/SpeedTorque/sgan/6411213a16cf40269e5727f56ff1dc4f.pt.g


# train gain
python neuralfaults/train_gans.py --gpu=0 --num_gpus=1  \
    --loss=mse,bce --metrics=smape,mae --dataset=SpeedTorque  \
    --impute_model=gain --inp_quants=i_d,i_q,u_d,u_q  \
    --out_quants=i_d,i_q,u_d,u_q --fail_quants=i_d,i_q,u_d,u_q  \
    --fail_quants_prob=0.1,0.1,0.1,0.1  --lr=0.1 --batch_size=4096 \
    --epochs=100


# train e2e
python neuralfaults/train_e2e.py --gpu=0 --num_gpus=1  \
    --loss=mse,bce --metrics=smape,mae --dataset=SpeedTorque  \
    --impute_model=e2e --inp_quants=i_d,i_q,u_d,u_q  \
    --out_quants=i_d,i_q,u_d,u_q --fail_quants=i_d,i_q,u_d,u_q  \
    --fail_quants_prob=0.1,0.1,0.1,0.1  --lr=0.1 --batch_size=4096 \
    --epochs=100

# train gan
python neuralfaults/train_gan.py --gpu=0 --num_gpus=1  \
    --loss=mse,bce --metrics=smape,mae --dataset=SpeedTorque  \
    --impute_model=gan --inp_quants=i_d,i_q,u_d,u_q  \
    --out_quants=i_d,i_q,u_d,u_q --fail_quants=i_d,i_q,u_d,u_q  \
    --fail_quants_prob=0.1,0.1,0.1,0.1  --lr=0.1 --batch_size=4096 \
    --epochs=100
