## CREATING THE ENVIRONMENT 

```bash
conda env create -f environment.yml
conda activate inrv
```

If you run into issues while creating the environment, please follow the steps outlined in https://github.com/ashawkey/torch-ngp repository for creating the environment, as we use torch-ngp as our backbone 


## TRAINING YOUR OWN Hyp-NeRF MODEL 
To train your own Hyp-NeRF model, we have provided a small toy dataset comprising of 10 abo_chair objects from ABO dataset -> https://amazon-berkeley-objects.s3.amazonaws.com/index.html

If you are in the hypnerf directory (current directory), you can find the dataset at -> toy_dataset/abo_small/

To train your own model, use the following command 

```bash
python main_nerf_toy.py toy_dataset/ --workspace {TRAINING_WORKSPACE_PATH} --bound 1 --scale 0.8 --dt_gamma 0
```

Please provide your own workspace path in place of the placeholder {TRAINING_WORKSPACE_PATH}. This is the path used for saving the intermediate checkpoints and results.


## DOWNLOADING OUR PRETRAINED CHECKPOINT 
We have also provided our pretrained checkpoint on 1038 instances from the abo_chairs dataset here -> https://zenodo.org/record/7965757/files/ngp_ep1765.pth?download=1

Please download the file and place it inside checkpoints folder in the current directory, such that it looks like -> checkpoints/ngp_ep1765.pth


## INVERSION USING AUTHORS' CHECKPOINT 
We have provided code for inverting an object from our pretrained checkpoint. You can provide a chair object id (from the list of object_ids in the abo_chairs dataset) in the object_id flag, such as the one shown below (B07BWJMB9F). To use our checkpoint, please don't forget to add 'authors_pretrained' flag. 'epochs_invert' specifies the number of epochs to invert for. Intermediate checkpoints and rendering results are added in the {INVERSION_WORKSPACE_DIR}, please provide your own path there.

```bash
python nerf_toy_invert.py toy_dataset/ --workspace {INVERSION_WORKSPACE_DIR} --bound 1 --scale 0.8 --dt_gamma 0 --object_id B07BWJMB9F --invert --authors_pretrained --epochs_invert 30
```

Please don't forget to add 'invert' flag during inversion. The code would fail to produce the desired behavior without this flag set. Also, if you don't set the 'authors_pretrained' flag, and fail to provide your own checkpoint, the code will result in an error.

## INVERSION USING YOUR OWN CHECKPOINT 
If you have trained Hyp-NeRF on your own dataset, and would like to invert an object using your own trained checkpoint, please use the command below. 

```bash
python nerf_toy_invert.py toy_dataset/ --workspace {INVERSION_WORKSPACE_DIR} --bound 1 --scale 0.8 --dt_gamma 0 --object_id B07BWJMB9F --invert --pretrained_ckpt {PATH_TO_YOUR_PREATRAINED_CHECKPOINT} --epochs_invert 30
```

Notice here that the flag 'authors_pretrained' is not set. Please provide your own pretrained checkpoint in place of the placeholder {PATH_TO_YOUR_PRETRAINED_CHECKPOINT}


## MULTI-POSE INVERSION 
We also allow inverting with multiple input camera poses. Please use the command below. 

```bash
python nerf_toy_invert.py toy_dataset/ --workspace {INVERSION_WORKSPACE_DIR} --bound 1 --scale 0.8 --dt_gamma 0 --invert --object_id B07B4M68LW --multiview_poses {NUM_POSES} --authors_pretrained --epochs_invert 30
```

You can set the number of input poses to invert from in {NUM_POSES}. We randomly choose {NUM_POSES} camera poses during inversion. Here, you can either use the 'authors_pretrained' flag to invert using our pretrained checkpoint, or provide your own checkpoint path with the 'pretrained_ckpt' flag. Typically, the quality of the NeRF improves with an increase in the number of camera poses. 


## RENDERING WITH AUTHORS' CHECKPOINT
To demonstrate the capability of Hyp-NeRF in compressing multiple object instances of a single category, we allow rendering a NeRF using one of the codebook ids. Please use the command below, 

```bash
python nerf_toy_invert.py toy_dataset/ --workspace {RENDER_WORKSPACE_DIR} --bound 1 --scale 0.8 --dt_gamma 0 --authors_pretrained --codebook_index 100
```

To render the NeRF at a fixed codebook index, provide the codebook id (example - 100). Please ensure that the codebook index is less than the total number of instances used for training Hyp-NeRF. Also note the missing 'invert' flag during rendering.


## RENDERING WITH YOUR OWN CHECKPOINT 
We also provide the ability to render using your own pretrained checkpoint. Please follow the command below, 

```bash
python nerf_toy_invert.py toy_dataset/ --workspace {RENDER_WORKSPACE_DIR} --bound 1 --scale 0.8 --dt_gamma 0 --pretrained_ckpt {PATH_TO_YOUR_PRETRAINED_CHECKPOINT} --codebook_index 5
```
You should add your pretrained checkpoint path at {PATH_TO_YOUR_PRETRAINED_CHECKPOINT}


## DEFINITION OF USEFUL FLAGS 
--invert                -> used to switch between inversion/rendering

--object_id             -> object id to invert 

--codebook_index        -> codebook index to render

--multiview_poses       -> number of camera poses used for inversion

--authors_pretrained    -> to use our pretrained checkpoint on abo_chairs

--pretrained_ckpt       -> provide the path to your own pretrained checkpoint 

--epochs_invert         -> number of epochs to run inversion for (typically, the loss converges within 15-20 epochs)

--render_resolution     -> resolution at which the NeRF is rendered (we provide 128, 256, 384, and 512 resolution)