library(ggplot2)
library(plyr)

args <- commandArgs(trailingOnly=TRUE)
dir <- args[1]


t <- read.table(paste(dir, "simulate_results", sep="/"), col.names=c("network", "target_ratio", "target", "bw", "algo", "mkspan", "used", "compute_cost", "transfer_cost", "compute_time"))
t$bw <- t$bw/(1024*1024*1.024)
bw_values <- unique(t$bw)
t$target <- t$target/(1024*1024*1024)

# Only consider image size of 500, remove resnet 18 and 34
t <- t[t$algo != "constrained" & grepl(":500:", t$network) & (!grepl(":18:", t$network)) & (!grepl(":34:", t$network)),]
# Rename persistent & pofo
t$algo <- revalue(t$algo, c("persistent"="rematerialization", "pofo"="POFO"))
# Remove image and batch size from the network description, they are all the same
levels(t$network) <- sub(":500:8$", "", levels(t$network))
levels(t$network) <- sub(":500:16$", "", levels(t$network))
levels(t$network) <- gsub(":", " ", levels(t$network))


u <- ddply(t, ~network, transform, mkspan_wrt_seq = mkspan/mkspan[algo=="sequential"])
u$algo <- factor(u$algo, levels=sort(levels(u$algo)))

t <- ddply(t[t$algo != "sequential",], ~network+target_ratio+target, transform, ratio_mkspan = mkspan/mkspan[algo=="rematerialization"], ratio_transfer = transfer_cost/mkspan)


p <- ggplot(u[u$algo != "sequential" & (u$bw == 12 | is.na(u$bw)),], aes(x=target_ratio, y=mkspan_wrt_seq, color=algo))
p <- p + geom_line() + geom_point() + facet_wrap(~network, nrow=2)
p <- p + xlab("Memory Ratio") + ylab("Overhead wrt sequential (for 12GB/s bandwidth)")
p <- p + coord_cartesian(ylim=c(1, 1.3))
p <- p + scale_color_discrete("Algorithm")
# p <- p + theme(legend.position="bottom")
ggsave(paste(dir, "perf_ratio.pdf", sep="/"), p, device=cairo_pdf, width=7, height=4)

p <- ggplot(u[u$algo != "sequential" & (u$bw == 12 | is.na(u$bw)),], aes(x=target, y=mkspan_wrt_seq, color=algo))
p <- p + geom_line() + geom_point() + facet_wrap(~network, nrow=2, scales="free_x")
p <- p + xlab("Memory Limit (GB)") + ylab("Overhead wrt sequential (for 12GB/s bandwidth)")
p <- p + coord_cartesian(ylim=c(1, 1.3))
p <- p + scale_color_discrete("Algorithm")
# p <- p + theme(legend.position="bottom")
ggsave(paste(dir, "perf_memory.pdf", sep="/"), p, device=cairo_pdf, width=7, height=4)


## 
p <- ggplot(u[u$algo != "sequential" & u$algo != "rematerialization" & u$target_ratio == 0.2,], aes(x=bw, y=mkspan_wrt_seq, color=algo))
p <- p + geom_hline(data=u[u$algo == "rematerialization" & u$target_ratio == 0.2,], aes(yintercept= mkspan_wrt_seq, color=algo))
p <- p + geom_line() + geom_point() + facet_wrap(~network, nrow=2)
p <- p + coord_cartesian(ylim=c(1, 1.4)) + scale_x_continuous(breaks=bw_values)
p <- p + scale_color_discrete("Algorithm")
# p <- p + theme(legend.position="bottom")
p <- p + xlab("Bandwidth (GB/s)") + ylab("Overhead wrt sequential (for memory ratio \u03B1=0.2)")
ggsave(paste(dir, "bw_perf.pdf", sep="/"), p, device=cairo_pdf, width=7, height=4)




# p<-ggplot(t[t$algo %in% c("pofo", "opportunist", "autocapper"),], aes(x=target_ratio, y=ratio_transfer, color=algo, shape=bw)) + geom_line() + geom_point() + facet_wrap(~network)
# p <- p + xlab("Memory Ratio") + ylab("Cost of transferred data relative to makespan")
# ggsave(paste(dir, "transfer.pdf", sep="/"), p, device="pdf", width=10, height=10)

t$ratio_compute <- t$compute_cost / t$mkspan
print(summary(t[t$algo %in% c("pofo"),"ratio_compute"]))
## print(t[!is.na(t$ratio_compute) & t$ratio_compute < 1,])
