## Anypos: Automated Task-Agnostic Actions for Bimanual Manipulation
# Installation Instructions
```bash
conda deactivate
conda create -n anypos python=3.10
conda activate anypos

pip install -e .
```

# Training IDM
To train IDM without arm-decoupling, run:
```bash
bash scripts/idm/train.sh
```
You need to replace the correct path to the training and test dataset in `scripts/idm/train.sh`, and assign a save path. The supported options for `model_name` are: `dino`, `direction-aware`, `resnet`.

To train IDM with arm-decoupling, run:
```bash
bash scripts/idm/train_split.sh
```
The supported options for `model_name` are: `dino_with_split`, `direction-aware_with_split`, `resnet_with_split`.

# Evaluation
To evaluate the trained IDM, run:
```bash
bash scripts/idm/eval.sh
```
You need to replace the correct path to the test dataset in `scripts/idm/eval.sh`, set the checkpoint, and assign a save path. The supported options for `model_name` are: `dino`, `direction-aware`, `resnet`. The code will additionally produce a visualization depicting the L1 error distribution for each qpos dimension.

To plot the attention heatmap of the model, run:
```bash
bash scripts/idm/plot_heatmap.sh
```
`learning_dim` is the learning dimension of the model, which can be used in all the above scripts. The default is `None`, which means the model is trained on all dimensions.