#!/bin/bash
timestamp=$(date "+%Y-%m-%d_%H-%M-%S")
accelerate launch \\
 --main_process_port=29344 plot_heatmap.py \\
 --learning_dim 2 \\
 --model_name direction_aware \\
 --load_from <checkpoint> \\
 --eval_batch_size 8 \\
 --learning_rate 5e-4 \\
 --use_normalization \\
 --use_transform \\
 --batch_size 8 \\
 --num_iterations 72000 \\
 --eval_interval 4000 \\
 --num_workers 32 \\
 --prefetch_factor 4 \\
 --dataset_path <test data dir> \\
 --test_dataset_path <test data dir> \\
 --save_dir <save dir> \\
 --dinov2_name facebook/dinov2-with-register-base \\
 --wandb_mode offline \\
 --run_name $timestamp \\
 --shuffle True > heatmap-$timestamp.log 2>&1 &