from main_marl import run_marl
from config import SUBSTRATE_NAME, EXTRA_SW_PROP


if __name__ == '__main__':
    coin_configs = [
        {'max_steps': 20, 'grid_size': 3},
        {'max_steps': 50, 'grid_size': 7},
    ]
    n_runs = 5

    for config in coin_configs:
        for seed in range(n_runs):
            save_path = f'{config["grid_size"]}_{config["max_steps"]}/seed_{seed}/'
            print(save_path)

            reward_type = None
            run_marl(SUBSTRATE_NAME, config, reward_type, save_path)

            reward_type = 'common_reward'
            SW_prop_low = run_marl(SUBSTRATE_NAME, config, reward_type, save_path)
            SW_prop_high = run_marl(SUBSTRATE_NAME, config, reward_type, save_path, extra_SW_prop=EXTRA_SW_PROP, train_principal=False)
            SW_prop_high -= EXTRA_SW_PROP

            reward_type = 'constant_proportion'
            run_marl(SUBSTRATE_NAME, config, reward_type, save_path, SW_prop=SW_prop_low)
            run_marl(SUBSTRATE_NAME, config, reward_type, save_path, SW_prop=SW_prop_high, extra_SW_prop=EXTRA_SW_PROP)
