import os
from matplotlib import animation
import matplotlib.pyplot as plt


def save_frames_as_gif(frames, path='./', filename='gym_animation.gif'):
    """
    From https://gist.github.com/botforge/64cbb71780e6208172bbf03cd9293553
    """
    if not os.path.exists(path):
        os.makedirs(path)

    # Mess with this to change frame size
    plt.figure(figsize=(frames[0].shape[1], frames[0].shape[0]), dpi=18)

    patch = plt.imshow(frames[0])
    plt.axis('off')

    def animate(i):
        patch.set_data(frames[i])

    anim = animation.FuncAnimation(plt.gcf(), animate, frames=len(frames), interval=1)
    anim.save(path + filename, fps=20)
    plt.close()
