"""
 Copyright (c) 2022, salesforce.com, inc.
 All rights reserved.
 SPDX-License-Identifier: BSD-3-Clause
 For full license text, see the LICENSE_Lavis file in the repo root or https://opensource.org/licenses/BSD-3-Clause
"""

import argparse
from torch.utils.data import DataLoader
import os
import json
import random
from minigpt4.common.eval_utils import prepare_texts, init_model, eval_parser
import numpy as np
import torch
import torch.backends.cudnn as cudnn
import wandb
from transformers import LlamaConfig
import minigpt4.tasks as tasks
from minigpt4.common.config import Config
from minigpt4.common.dist_utils import get_rank, init_distributed_mode
from minigpt4.common.logger import setup_logger
from minigpt4.common.optims import (
    LinearWarmupCosineLRScheduler,
    LinearWarmupStepLRScheduler,
)
from minigpt4.common.registry import registry
from minigpt4.common.utils import now
import os
# os.environ['CUDA_VISIBLE_DEVICES'] = '0,1'
# imports modules for registration

from minigpt4.datasets.builders import *
from minigpt4.models import *
from minigpt4.processors import *
from minigpt4.runners import *
from minigpt4.tasks import *


def parse_args():
    parser = argparse.ArgumentParser(description="Training")

    parser.add_argument("--cfg-path", required=True, help="path to configuration file.")
    parser.add_argument(
        "--options",
        nargs="+",
        help="override some settings in the used config, the key-value pair "
        "in xxx=yyy format will be merged into config file (deprecate), "
        "change to --cfg-options instead.",
    )
    args = parser.parse_args()

    return args


def setup_seeds(config):
    seed = config.run_cfg.seed + get_rank()

    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)

    cudnn.benchmark = False
    cudnn.deterministic = True


def get_runner_class(cfg):
    """
    Get runner class from config. Default to epoch-based runner.
    """
    # print(cfg.run_cfg.get("runner", "runner_base"))
    runner_cls = registry.get_runner_class(cfg.run_cfg.get("runner", "runner_base"))
    # print(runner_cls)
    # exit()

    return runner_cls


def find_all_linear_names(model):
    cls = torch.nn.Linear
    lora_module_names = set()
    for name, module in model.named_modules():
        # print(name)
        if 'llama_model' not in name:
            continue
        if isinstance(module, cls):
            names = name.split('.')
            lora_module_names.add(names[0] if len(names) == 1 else names[-1])
    if 'lm_head' in lora_module_names: # needed for 16-bit
        lora_module_names.remove('lm_head')
    return list(lora_module_names)
def rank0_print(*args):
    # if local_rank == 0:
    print(*args)
class LlavaConfig(LlamaConfig):
    model_type = "llava"
def main():
    # allow auto-dl completes on main process without timeout when using NCCL backend.
    # os.environ["NCCL_BLOCKING_WAIT"] = "1"

    # set before init_distributed_mode() to ensure the same job_id shared across all ranks.

    args = parse_args()
    # print(args)
    # exit()
    cfg = Config(args)
    # print(cfg.model_cfg.lora_enable)


    # print(cfg.config['mo'])
    # exit()
    job_id = cfg.model_cfg.job_name
    # print('cfg',cfg.model_cfg.lora_enable)
    # exit()

    init_distributed_mode(cfg.run_cfg)
    setup_seeds(cfg)
    # set after init_distributed_mode() to only log on master.
    setup_logger()
    cfg.pretty_print()
    iter_per_epch=cfg.run_cfg.iter_per_epoch
    # print(cfg.run_cfg.distributed)
    # exit()

    #
    task = tasks.setup_task(cfg)
    # print('task',task)
    # exit()
    # print(cfg)
    # exit()
    datasets,eval_dataset = task.build_datasets(cfg)
    # print(datasets)
    # exit()
    # sample_id_list=json.load()
    # task.sample_id_list =
    if eval_dataset is not None:
        eval_dataloader = DataLoader(eval_dataset, batch_size=2, shuffle=False)
    else:
        eval_dataloader=None
    # a=list()
    # print(eval_dataset[0])
    # a.append(eval_dataset[0][1])
    # print(tuple(a))
    # exit()
    # for data in eval_dataloader:
    #     print(data,data[0].device,data[0].shape)
    #     exit()
    # exit()
    # print('data',eval_dataset)
    # exit()
    # print('hello')
    model = task.build_model(cfg)
    # print('model',model)
    # print(cfg.get("lora_enable", False))
    # exit()
    cfg.model_cfg.lora_enable=False
    ref_model = task.build_model(cfg)
    # print('hello')
    # print('model',model)
    # print(ref_model)
    # exit()
    # for name, parms in model.named_parameters():
    #     print('name', name)
    #     print("requires_grad", parms.requires_grad)
    # exit()
    # print

    # exit()
    # print('datasets',datasets)
    # exit()
    trainable_params = sum(p.numel() for p in model.parameters() if p.requires_grad)
    # print(trainable_params)
    # for p in model.llama_proj.parameters(): ####Trojanmllm
    #     p.requires_grad = True
    # for name, parms in model.named_parameters():
    #     print('name', name)
    #     print("requires_grad", parms.requires_grad)
    # exit()
    trainable_params = sum(p.numel() for p in model.parameters() if p.requires_grad)
    # print(trainable_params)

    # exit()
    if cfg.run_cfg.wandb_log:
        wandb.login()
        wandb.init(project="minigptv", name=cfg.run_cfg.job_name)
        wandb.watch(model)
    # coin_flip=cfg.run_cfg.coin_flip
    # print(get_runner_class(cfg))
    # exit()
    # print('model1',model)
    # print(coin_flip)
    runner = get_runner_class(cfg)(
        cfg=cfg, job_id=job_id, task=task, model=model,ref_model=ref_model, datasets=datasets,eval_dtloader=eval_dataloader,eval_dataset=eval_dataset,iter_per_epch=iter_per_epch,output_attentions=False)
    runner.train()


if __name__ == "__main__":
    main()
