## LongHorizonUI: 基于视觉的长序列自动化执行GUI Agent框架

LongHorizonUI 旨在实现通用的 GUI 自动化，它能够自动化执行**图形用户界面 (GUI)** 任务。它利用多模态大模型来理解屏幕上的视觉内容并执行相应操作，以模拟人类的交互方式。

## 🌟 主要特性

*   **GUI 自动化:** 提供与不同应用程序 GUI 元素交互的工具和 Agent。
*   **录制动作转译:** 将使用特定工具录制的用户交互序列（如 Android 屏幕截图、触摸事件）转换为结构化的自然语言步骤描述。
*   **自然语言任务执行:** 通过自然语言指令，执行复杂的多步骤任务。
*   **灵活的 LLM 集成:** 支持集成多种视觉语言模型 (VLM)，例如 Google Gemini 和 Azure OpenAI (GPT-4o)。

---

## 🚀 快速上手

### 1. 环境要求

运行**提供的 Android 示例**需要满足以下先决条件：

*   一台 Android 设备。
*   设备上已启用 **开发者模式**。
*   在开发者选项中已启用 **USB 调试**。
*   使用 USB 数据线将设备连接到电脑，并在 USB 连接模式中选择 **文件传输**。
*   在电脑上安装 [uv](https://github.com/astral-sh/uv#installation)。请根据您的操作系统遵循官方指南进行安装。

*注意：针对其他潜在 GUI 平台的自动化可能需要不同的环境要求。*

### 2. 安装步骤
```

使用 `uv` 设置 Python 环境并安装依赖：

```bash
# 该命令会根据 pyproject.toml 文件安装所有必需的 Python 包
uv sync
```

### 3. ⚙️ 环境配置

配置您计划使用的**大语言模型 (LLM)** 的 API 密钥。

*   复制示例环境变量文件：
    ```bash
    cp .env.example .env
    ```
*   编辑 `.env` 文件，填入相应的变量值。您**只需配置**您计划使用的模型提供商（Azure OpenAI 或 Google Gemini）。

    ```dotenv
    # --- Azure OpenAI ---
    AZURE_OPENAI_ENDPOINT="<YOUR_AZURE_OPENAI_ENDPOINT>"
    AZURE_OPENAI_API_KEY="<YOUR_AZURE_OPENAI_API_KEY>"

    # --- Google Gemini ---
    GOOGLE_APPLICATION_CREDENTIALS="<PATH_TO_YOUR_SERVICE_ACCOUNT_JSON>" 
    GOOGLE_PROJECT="<YOUR_GOOGLE_CLOUD_PROJECT_ID>"
    GOOGLE_LOCATION="<YOUR_GOOGLE_CLOUD_LOCATION>" 
    ```
    **注意:** 关于 `AZURE_*` 和 `GOOGLE_*` 凭证的具体获取和配置细节，请与 **shaoguowen** 确认。

### 4. 验证 ADB 连接 (针对 Android 示例)

确保您的电脑可以通过 ADB (Android Debug Bridge) 识别已连接的 Android 设备：

```bash
adb devices
```

输出应列出您的设备序列号。如果未列出，请检查 USB 连接、驱动程序安装以及设备上的 USB 调试授权。

---

## 📝 Agent 使用示例

以下示例演示了核心 Agent 的功能，以 **Android 作为目标环境**。具体实现细节请参考 `tests/test_agents.py` 中的测试脚本。

### Agent 1: 录制转步骤 Agent

此 Agent 处理通过特定工具（详见 `tools/android_record/README.md`）捕获的录制交互数据（截图、触摸事件等），并将其转换为人类可读的操作步骤序列。

*   **运行示例:** 参考 `tests/test_agents.py` 中的 `test_record_to_simple_steps()` 函数。
    *   修改 `record_dir` 变量，使其指向您实际的录制数据文件夹。
    *   在脚本中配置所需的 LLM 提供商 (Gemini 或 Azure OpenAI)。
    *   执行该 Python 函数。
*   **输出:** 函数将输出一个 JSON 对象 (`task_infos`)，包含：
    *   `task`: 对整个录制任务的自然语言摘要。
    *   `task_steps`: 与录制动作对应的离散自然语言步骤列表。

**代码片段示例 (源自 `tests/test_agents.py`):**

```python
# tests/test_agents.py

def test_record_to_simple_steps():
    # ... (LLM 初始化代码，如同测试文件中所示) ...

    # 指定录制数据目录
    record_dir = "data/record_data/dnfm/1742544335.1320004" # 替换为您的实际路径

    agent = RecordToSimpleStepsAgent(llm)
    task_infos = agent.execute(record_dir=record_dir, temperature=0.1)

    # 打印结果
    import json
    # 使用 ensure_ascii=False 以便在控制台正确显示中文等非 ASCII 字符
    print(json.dumps(task_infos, indent=2, ensure_ascii=False))
```

### Agent 2: 自动化执行 Agent

此 Agent 接收自然语言描述的任务，并尝试在连接的 Android 设备上自动执行该任务。

*   **运行示例:** 参考 `tests/test_agents.py` 中的 `test_android_auto_exec_agent()` 函数。
    *   确保 Android 设备已按前述步骤连接并被 `adb` 识别。
    *   配置所需的 LLM 提供商。
    *   定义您希望执行的任务 `task` (例如："打开计算器，计算123加456等于多少")。`task_steps` 和 `task_infos` 参数通常可以留空，让 Agent 自行规划。
    *   执行该 Python 函数。
*   **输出:** 函数将返回一个输出目录的路径 (`agent_output_dir`)。该目录包含：
    *   一个 `gif` 文件，可视化展示 Agent 的完整执行过程。
    *   一个 `json` 文件，记录了执行过程中每一步的详细信息，包括状态观察、LLM 推理和执行的动作。

**代码片段示例 (源自 `tests/test_agents.py`):**

```python
# tests/test_agents.py

def test_android_auto_exec_agent():
    # ... (LLM, AndroidContext, Controller, AgentConfig 的设置代码，如同测试文件中所示) ...

    agent = AutoExecutionAgent(
        # ... (传入已配置好的对象) ...
    )

    # 定义自然语言任务
    task = "打开设置，查看WLAN设置"
    # task = "打开小红书，找到法意瑞自由行的最佳攻略，转发给目前在线的一个QQ好友" # 示例任务
    task_steps = "" # 可选：提供预定义的步骤
    task_infos = "" # 可选：提供额外的上下文信息

    # 运行 Agent
    agent_output_dir = agent.run(task, task_steps=task_steps, task_infos=task_infos)

    print(f"Agent 执行完成。输出已保存至: {agent_output_dir}")
```

---

## 💻 开发自定义 Agent/脚本

建议在项目根目录下创建一个 `examples/` 文件夹，用于存放您自己的测试脚本和 Agent 实现，以避免直接修改 `tests/` 目录下的核心测试代码。

```bash
mkdir examples
cd examples
# 在此目录下创建您的 Python 脚本 (例如 my_custom_agent_test.py)
# 您可以复制 tests/test_agents.py 中的代码作为起点进行修改。
```