# -*- coding: utf-8 -*-
# @Time    : 2025/2/18
# @Author  : shaoguowen
# @Email   : wenshaoguo0611@gmail.com
# @Project : qagent-web
# @FileName: encrypt_env_file.py

import os
import base64
from cryptography.fernet import Fernet
import argparse  # Import the argparse module
from cryptography.fernet import Fernet


def encrypt_env_file(env_file_path, output_file_path, key_file_path):
    """Reads an .env file, encrypts it using a Fernet key, and saves it to a file.

    Args:
        env_file_path (str): Path to the input .env file.
        output_file_path (str): Path to the output encrypted file.
        key_file_path (str): Path to the key file.
    """
    try:
        if not os.path.exists(key_file_path):
            key = Fernet.generate_key()
            os.makedirs(os.path.dirname(key_file_path), exist_ok=True)
            with open(key_file_path, "wb") as key_file:
                key_file.write(key)

        with open(key_file_path, "rb") as key_file:
            key = key_file.read()
        f = Fernet(key)

        with open(env_file_path, 'r') as file:
            env_content = file.read().encode('utf-8')  # Read and encode as bytes

        encrypted_content = f.encrypt(env_content)  # Encrypt

        with open(output_file_path, 'wb') as file:  # Write the encrypted content as binary
            file.write(encrypted_content)

        print(f"Encrypted .env file saved to: {output_file_path}")

    except FileNotFoundError:
        print(f"Error: Could not find file: {env_file_path}, {output_file_path}, or the key file")
    except Exception as e:
        print(f"An error occurred: {e}")


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='Encrypt an .env file.')
    parser.add_argument('env_file', help='Path to the input .env file')
    parser.add_argument('output_file', help='Path to the output encrypted file')
    parser.add_argument('--key_file', default="data/secret_keys/secret.key", help='Path to the key file')

    args = parser.parse_args()

    encrypt_env_file(args.env_file, args.output_file, args.key_file)
