# -*- coding: utf-8 -*-
# @Time    : 2025/2/18
# @Author  : shaoguowen
# @Email   : wenshaoguo0611@gmail.com
# @Project : qagent-web
# @FileName: gen_secret_key.py
import os

from cryptography.fernet import Fernet


def generate_key():
    """生成 Fernet 密钥并保存到文件。"""
    key = Fernet.generate_key()
    save_dir = "data/secret_keys/"
    os.makedirs(save_dir, exist_ok=True)
    with open(os.path.join(save_dir, "secret.key"), "wb") as key_file:
        key_file.write(key)
    save_path = os.path.join(save_dir, "secret.key")
    print(f"密钥已生成并保存到: {save_path}")


if __name__ == "__main__":
    generate_key()
