import pdb
import os
import json
import numpy as np
import logging
import sys
from pathlib import Path
import adbutils
from adbutils import AdbError
from pathlib import Path
import json
import time

sys.path.append(".")




def test_android_auto_exec_agent():
    import os
    import json
    from pathlib import Path
    from typing import Dict, List, Any

    from qagent_omni.common import llm_provider, utils
    from qagent_omni.agent.auto_execution_agent_androidcontrol import AutoExecutionAgent, AutoExecutionConfig
    from qagent_omni.system.android_context import AndroidContext, AndroidContextConfig
    from qagent_omni.controller.android_controller import AndroidController
    from qagent_omni.prompts.auto_execution_prompt import AndroidExecSystemPrompt, AutoExecAgentPrompt
    from test_evalution_androidcontrol import evaluate_action_performance
    from qagent_omni.common.llm_provider import LLMProvider

    # 1. 配置AndroidControl数据集路径
    android_control_root = Path("data/android_control")
    android_control_images = android_control_root / "android_control_images"
    test_json_path = android_control_root / "android_control_test.json"
    output_base_dir = Path("./tmp/android_control_outputs")

    # 2. 加载测试数据
    with open(test_json_path, 'r', encoding='utf-8') as f:
        test_data = json.load(f)  # 加载整个JSON列表

    # 3. 初始化模型
    model = "gemini-2.5-pro"
    project = os.getenv("GOOGLE_PROJECT", "")
    location = os.getenv("GOOGLE_LOCATION", "")
    llm = llm_provider.LLMProvider(llm_provider="gemini", model=model, project=project, location=location)

    # 4. 遍历每个demo场景
    for item in test_data:  # 遍历每个顶层字典
        episode = item["episode"]  # 获取嵌套的episode字典
        episode_id = episode["episode_id"]  # 正确访问路径
        task_name = episode["goal"]
        task_steps = "\n".join(
            [f"{i + 1}. {step}" for i, step in enumerate(episode["step_instructions"])]
        )
        screenshot_dir = android_control_images / str(episode_id)

        # 后续使用episode字段（而非整个item）
        width = item.get("width", 1080)
        height = item.get("height", 2400)
        step_check_pams = item.get("step_check_pams", [])

        print(f"\n{'=' * 60}")
        print(f"开始处理场景: {task_name} (ID: {episode_id})")
        print(f"{'=' * 60}")

        # 5. 准备输出目录
        task_output_dir = output_base_dir / str(episode_id)
        task_output_dir.mkdir(parents=True, exist_ok=True)

        # 6. 初始化Android上下文
        context_config = AndroidContextConfig(
            local_screenshot_dir=str(screenshot_dir),
            use_perception=True,
            use_ocr=True,
            use_ocr_rec=False,
            perception_description_type="normal",
            highlight_grid_num=24,
            screenshot_save_dir=str(task_output_dir),
            detect_split_x=2,
            detect_split_y=2,
        )
        system_context = AndroidContext(config=context_config)
        controller = AndroidController(highlight_action=True)

        # 7. 配置代理
        agent_config = AutoExecutionConfig(
            max_steps=100,
            llm_temperature=0.4,
            max_input_len=60,
            keep_last_n_states=2,
        )
        agent = AutoExecutionAgent(
            agent_config=agent_config,
            controller=controller,
            system_context=system_context,
            llm=llm,
            system_prompt_class=AndroidExecSystemPrompt,
            agent_prompt_class=AutoExecAgentPrompt,
            task_dir=screenshot_dir,  # 直接使用截图目录
        )

        # 8. 执行任务
        try:
            print(f"开始执行: {task_name}")
            print(f"截图目录: {screenshot_dir}")
            print(f"输出目录: {task_output_dir}")

            if hasattr(system_context, 'reset_screenshot_index'):
                system_context.reset_screenshot_index()

            agent_output_dir = agent.run(
                task=task_name,
                task_steps=task_steps,
                task_infos=f"AndroidControl Demo ID: {episode_id}"
            )
            print(f"任务完成，输出保存在: {agent_output_dir}")

        except Exception as e:
            import traceback
            print(f"任务执行异常: {str(e)}")
            traceback.print_exc()
            continue

        # 9. 评估执行结果
        try:
            predictions_path = Path(agent_output_dir) / "action_records.json"
            if not predictions_path.exists():
                print(f"跳过评估: 预测文件不存在")
                continue

            # 直接传入episode对象作为ground truth[2](@ref)
            metrics = evaluate_action_performance(
                predictions_path=str(predictions_path),
                ground_truth_episode=episode,  # 关键修改点
                output_dir=str(agent_output_dir)
            )

            # 10. 打印评估结果
            if metrics:
                print(f"\n[评估结果] {task_name}:")
                print(f"  Type匹配率: {metrics['type_match_acc']:.2f}%")
                print(f"  坐标定位率: {metrics['grounding_accuracy']:.2f}%")
                print(f"  步骤成功率: {metrics['step_success_rate']:.2f}%")

                # 特殊动作类型统计[3](@ref)
                for action_type in ['click', 'long_press', 'swipe', 'input_text', 'open_app']:
                    if action_type in metrics:
                        print(f"  {action_type}动作准确率: {metrics[action_type]:.2f}%")

        except Exception as e:
            print(f"评估失败: {e}")


if __name__ == '__main__':
    test_android_auto_exec_agent()