import os
import zipfile
import shutil
from pathlib import Path


def collect_and_zip_files(source_dir, output_zip):
    """
    收集指定目录下每个子文件夹中的特定文件/文件夹并压缩为zip
    """
    source_path = Path(source_dir)
    # 确保源目录存在
    if not source_path.exists() or not source_path.is_dir():
        print(f"Error: Source directory not found: {source_path}")
        return

    with zipfile.ZipFile(output_zip, 'w', zipfile.ZIP_DEFLATED) as zipf:
        # 遍历每个子目录
        for subdir in source_path.iterdir():
            if not subdir.is_dir():
                continue

            dir_name = subdir.name
            print(f"Processing directory: {dir_name}")

            # 收集需要打包的文件/文件夹
            files_to_zip = [
                (subdir / "screenshot", f"{dir_name}/screenshot"),
                (subdir / "screenshot_draw", f"{dir_name}/screenshot_draw"),
                (subdir / "task_infos.json", f"{dir_name}/task_infos.json")
            ]

            # 添加到zip文件
            for source, dest in files_to_zip:
                if not source.exists():
                    print(f"  Warning: Not found: {source}")
                    continue

                if source.is_dir():
                    # 递归添加目录
                    for root, dirs, files in os.walk(source):
                        for file in files:
                            file_path = Path(root) / file
                            # 计算在zip中的相对路径
                            rel_path = Path(dest) / file_path.relative_to(source)
                            zipf.write(file_path, rel_path)
                            # print(f"  Added: {rel_path}")
                else:
                    # 添加单个文件
                    zipf.write(source, dest)
                    # print(f"  Added: {dest}")

    # print(f"\nSuccess! All files compressed to: {output_zip}")


if __name__ == "__main__":
    # 配置路径
    source_directory = r"data/mdnf"
    output_zip_file = r"data\all_task_data.zip"

    collect_and_zip_files(source_directory, output_zip_file)