import os
import cv2
import argparse
def video2frames(video_path, video_name):
    
    # Create output directory
    # output_dir = os.path.join('frames', video_name)
    output_dir = os.path.join('frames', video_name)
    os.makedirs(output_dir, exist_ok=True)

    # Open video file
    video = cv2.VideoCapture(video_path)
    
    frame_idx = 0
    while True:
        # Read frame
        ret, frame = video.read()
        if not ret:
            break
            
        # Save frame as PNG
        output_path = os.path.join(output_dir, f'{frame_idx:04d}.png')
        cv2.imwrite(output_path, frame)
        
        frame_idx += 1
    
    video.release()
    return output_dir

if __name__ == "__main__":
    # Process all videos in data directory
    # data_dir = "data"
    
    parser = argparse.ArgumentParser()
    # parser.add_argument("--video_name", type=str, required=True)
    parser.add_argument("--video_root_path", type=str, required=True)
    parser.add_argument("--render", action="store_true", help="Process render.mp4 files")
    args = parser.parse_args()
    # video_name = args.video_name
    video_root_path = args.video_root_path
    if args.render:
        subfolder = video_root_path.split('/')[-1]
    
    for video_file in os.listdir(video_root_path):
        if args.render:
            if video_file == "render.mp4":  
                video_path = os.path.join(video_root_path, video_file)
                print(f"Processing {video_file}...")
                video_name = video_path.split('/')[-2]
                subfolder = video_path.split('/')[-3]
                output_frames_name = f'render_{subfolder}_{video_name}'
                if os.path.exists(os.path.join('frames', output_frames_name)):
                    continue
                video2frames(video_path, output_frames_name)
        else:
            # if video_file == "input.mp4":
            if os.path.exists(os.path.join('frames', video_file[:-4])):
                continue
            video_path = os.path.join(video_root_path, video_file)
            print(f"Processing {video_file}...")
            video2frames(video_path, video_file[:-4])
