import os
from diffusers.utils import export_to_video
from PIL import Image

def create_videos_from_frames(root_folder):
    # Iterate through all subfolders in root folder
    for video_name in os.listdir(root_folder):
        video_path = os.path.join(root_folder, video_name)
        
        # Skip if not a directory
        if not os.path.isdir(video_path):
            continue

        # Skip if the video is already processed
        if os.path.exists(f'controls/{video_name}.mp4'):
            continue
            
        # Get all frame files and sort them
        frame_files = sorted([f for f in os.listdir(video_path) if f.endswith(('.png', '.jpg', '.jpeg'))])
        
        if not frame_files:
            print(f"No frames found in {video_path}")
            continue
            
        # Load all frames
        frames = []
        for frame_file in frame_files:
            frame_path = os.path.join(video_path, frame_file)
            frame = Image.open(frame_path)
            frames.append(frame)
            
        # Export to video
        export_to_video(frames, f"controls/control_{video_name}.mp4", fps=30)
        print(f"Created video for {video_name}")

if __name__ == "__main__":
    # Specify the root folder containing frame subfolders
    root_folder = "controls"
    create_videos_from_frames(root_folder)
