
import cadquery as cq

# Define the dimensions of the rectangle and the hole
length = 0.75  # Length of the rectangle
width = 0.19  # Width of the rectangle
thickness = 0.01  # Thickness of the rectangle
hole_diameter = 0.01  # Diameter of the hole

# Check if inputs are valid
if length <= 0 or width <= 0 or thickness <= 0 or hole_diameter <= 0:
    raise ValueError("All dimensions must be greater than zero.")

# Create the rectangle with the hole
result = (
    cq.Workplane("XY")
    .box(length, width, thickness)
    .faces(">Z")
    .workplane()
    .hole(hole_diameter)
)

# Export the result to an STL file
result.val().exportStl("Refine_1.stl")
