
import cadquery as cq

# Define the dimensions of the cylinder and the cutout
diameter = 100.0  # Diameter of the cylinder
height = 50.0  # Height of the cylinder
cutout_diameter = 20.0  # Diameter of the cutout

# Create the large cylinder
result = cq.Workplane("XY").circle(diameter / 2.0).extrude(height)

# Create the cutout at the center of the cylinder
result = result.faces(">Z").workplane().circle(cutout_diameter / 2.0).cutThruAll()

# Export the result
result.val().exportStl("Refine_2.stl")
